/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.utils;

import java.util.Objects;
import java.util.function.Predicate;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.dataset.DatasetTransformer;
import ws.palladian.core.dataset.FeatureInformation;
import ws.palladian.core.value.NumericValue;
import ws.palladian.core.value.Value;
import ws.palladian.helper.collection.Vector;

public class InstanceValueRelativizer
implements DatasetTransformer {
    private final Predicate<? super String> filter;

    public InstanceValueRelativizer(Predicate<? super String> filter) {
        this.filter = Objects.requireNonNull(filter);
    }

    public Instance apply(Instance input) {
        int bowSum = 0;
        for (Vector.VectorEntry entry : input.getVector()) {
            if (!this.filter.test((String)entry.key())) continue;
            if (entry.value() instanceof NumericValue) {
                bowSum = (int)((double)bowSum + ((NumericValue)entry.value()).getDouble());
                continue;
            }
            throw new IllegalArgumentException("Value " + (String)entry.key() + " is not of type " + NumericValue.class + ", but " + ((Value)entry.value()).getClass() + ", cannot relativize.");
        }
        InstanceBuilder builder = new InstanceBuilder();
        for (Vector.VectorEntry entry : input.getVector()) {
            if (this.filter.test((String)entry.key())) {
                double frequency = 0.0;
                if (bowSum > 0) {
                    frequency = ((NumericValue)entry.value()).getDouble() / (double)bowSum;
                }
                builder.set((String)entry.key(), frequency);
                continue;
            }
            builder.set((String)entry.key(), (Value)entry.value());
        }
        return builder.create(input.getCategory());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.filter + ")";
    }

    public FeatureInformation getFeatureInformation(FeatureInformation featureInformation) {
        return featureInformation;
    }
}

