/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.utils;

import java.util.Set;
import ws.palladian.helper.collection.CollectionHelper;

public class MultilabelEvaluator {
    private double cumulatedPrecision;
    private double cumulatedRecall;
    private int count;

    public <T> Result add(Set<T> trueLabels, Set<T> assignedLabels) {
        int intersectionSize = CollectionHelper.intersect(trueLabels, assignedLabels).size();
        int trueSize = trueLabels.size();
        int assignedSize = assignedLabels.size();
        double precision = assignedSize != 0 ? (double)intersectionSize / (double)assignedSize : 1.0;
        double recall = trueSize != 0 ? (double)intersectionSize / (double)trueSize : 1.0;
        this.cumulatedPrecision += precision;
        this.cumulatedRecall += recall;
        ++this.count;
        return new Result(precision, recall);
    }

    public Result getResult() {
        if (this.count == 0) {
            throw new IllegalStateException("no values were added");
        }
        return new Result(this.cumulatedPrecision / (double)this.count, this.cumulatedRecall / (double)this.count);
    }

    public int getCount() {
        return this.count;
    }

    public static final class Result {
        private final double precision;
        private final double recall;

        protected Result(double precision, double recall) {
            this.precision = precision;
            this.recall = recall;
        }

        public double getPrecision() {
            return this.precision;
        }

        public double getRecall() {
            return this.recall;
        }

        public double getF1() {
            return 2.0 * this.getPrecision() * this.getRecall() / (this.getPrecision() + this.getRecall());
        }

        public String toString() {
            return "Precision=" + this.precision + ", Recall=" + this.recall + ", F1=" + this.getF1();
        }
    }
}

