/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.utils;

import java.io.File;
import java.util.Iterator;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.palladian.classification.utils.CsvDatasetReader;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.Instance;
import ws.palladian.core.value.NumericValue;
import ws.palladian.core.value.Value;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.helper.collection.Vector;

public final class NaNInfiniteInstanceFilter
extends Enum<NaNInfiniteInstanceFilter>
implements Predicate<Instance> {
    public static final /* enum */ NaNInfiniteInstanceFilter FILTER = new NaNInfiniteInstanceFilter();
    private static final Logger LOGGER;
    private static final /* synthetic */ NaNInfiniteInstanceFilter[] $VALUES;

    public static NaNInfiniteInstanceFilter[] values() {
        return (NaNInfiniteInstanceFilter[])$VALUES.clone();
    }

    public static NaNInfiniteInstanceFilter valueOf(String name) {
        return Enum.valueOf(NaNInfiniteInstanceFilter.class, name);
    }

    @Override
    public boolean test(Instance item) {
        FeatureVector featureVector = item.getVector();
        for (Vector.VectorEntry entry : featureVector) {
            Value value = (Value)entry.value();
            if (!(value instanceof NumericValue)) continue;
            double doubleValue = ((NumericValue)value).getDouble();
            if (Double.isNaN(doubleValue)) {
                LOGGER.warn("Skipping instance with NaN @ {}", entry.key());
                return false;
            }
            if (!Double.isInfinite(doubleValue)) continue;
            LOGGER.warn("Skipping instance with Infinity @ {}", entry.key());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Object instances = new CsvDatasetReader(new File("/Users/pk/Desktop/tmp/yelp_features_medium_test_1455386873613.csv"));
        instances = CollectionHelper.filter((Iterable)instances, (Predicate)FILTER);
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            assert (instance != null);
        }
    }

    static {
        $VALUES = new NaNInfiniteInstanceFilter[]{FILTER};
        LOGGER = LoggerFactory.getLogger(NaNInfiniteInstanceFilter.class);
    }
}

