/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class PlexusXFireTest
extends PlexusTestCase {
    private Map namespaces = new HashMap();

    protected void printNode(Node node) throws Exception {
        XMLWriter writer = new XMLWriter(OutputFormat.createPrettyPrint());
        writer.setOutputStream((OutputStream)System.out);
        writer.write(node);
    }

    protected Document invokeService(String service, String document) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageContext context = new MessageContext(service, null, (OutputStream)out, null, null);
        this.getXFire().invoke(this.getResourceAsStream(document), context);
        SAXReader reader = new SAXReader();
        return reader.read((InputStream)new StringInputStream(out.toString()));
    }

    protected Document getWSDLDocument(String service) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(service, (OutputStream)out);
        SAXReader reader = new SAXReader();
        return reader.read((InputStream)new StringInputStream(out.toString()));
    }

    protected void setUp() throws Exception {
        BasicConfigurator.configure();
        super.setUp();
        this.addNamespace("s", Soap11.getInstance().getNamespace());
        this.addNamespace("soap12", Soap12.getInstance().getNamespace());
    }

    public void assertValid(String xpath, Node node) throws Exception {
        List nodes = this.createXPath(xpath).selectNodes((Object)node);
        if (nodes.size() == 0) {
            throw new Exception("Failed to select any nodes for expression:.\n" + xpath + "\n" + node.asXML());
        }
    }

    public void assertInvalid(String xpath, Node node) throws Exception {
        List nodes = this.createXPath(xpath).selectNodes((Object)node);
        if (nodes.size() > 0) {
            throw new Exception("Found multiple nodes for expression:\n" + xpath + "\n" + node.asXML());
        }
    }

    public void assertXPathEquals(String xpath, String value, Node node) throws Exception {
        String value2 = this.createXPath(xpath).selectSingleNode((Object)node).getText().trim();
        PlexusXFireTest.assertEquals((String)value, (String)value2);
    }

    public void assertNoFault(Node node) throws Exception {
        this.assertInvalid("/s:Envelope/s:Body/s:Fault", node);
    }

    protected XPath createXPath(String xpathString) {
        XPath xpath = DocumentHelper.createXPath((String)xpathString);
        xpath.setNamespaceURIs(this.namespaces);
        return xpath;
    }

    public void addNamespace(String ns, String uri) {
        this.namespaces.put(ns, uri);
    }

    protected WSDLWriter getWSDL(String service) throws Exception {
        ServiceRegistry reg = this.getServiceRegistry();
        Service hello = reg.getService(service);
        return hello.getWSDLWriter();
    }

    protected XFire getXFire() throws Exception {
        return (XFire)this.lookup(XFire.ROLE);
    }

    protected ServiceRegistry getServiceRegistry() throws Exception {
        return this.getXFire().getServiceRegistry();
    }
}

