/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.xfire.plexus.PlexusXFireComponent;
import org.codehaus.xfire.plexus.config.ConfigurationService;
import org.codehaus.xfire.plexus.config.Configurator;
import org.codehaus.xfire.service.Service;

public class DefaultConfigurationService
extends PlexusXFireComponent
implements Initializable,
Contextualizable,
ConfigurationService {
    private PlexusContainer container;
    private Hashtable configurators = new Hashtable();

    public void initialize() throws Exception {
        try {
            List confs = this.getServiceLocator().lookupList(Configurator.ROLE);
            Iterator itr = confs.iterator();
            while (itr.hasNext()) {
                Configurator conf = (Configurator)itr.next();
                this.register(conf);
            }
            Reader reader = this.findConfigurationReader();
            if (reader == null) {
                return;
            }
            XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)reader));
            this.createServices(configuration.getChild("services"));
        }
        catch (Exception e) {
            this.getLogger().error("Could not start the configuration service.", (Throwable)e);
            throw e;
        }
    }

    private void createServices(PlexusConfiguration child) throws Exception {
        PlexusConfiguration[] service = child.getChildren("service");
        for (int i = 0; i < service.length; ++i) {
            this.createService(service[i]);
        }
    }

    private void createService(PlexusConfiguration c) throws Exception {
        String type = c.getChild("type").getValue("simple");
        if (type == null) {
            this.getLogger().error("Service " + c.getAttribute("name") + " has no type.");
            return;
        }
        this.getLogger().info("Creating service " + c.getChild("name").getValue() + " with type " + type);
        Configurator builder = (Configurator)this.getServiceLocator().lookup(Configurator.ROLE, type);
        if (builder == null) {
            this.getLogger().error("Error creating service " + c.getAttribute("name") + ": No Configurator.");
            return;
        }
        Service service = builder.createService(c);
    }

    protected Reader findConfigurationReader() throws FileNotFoundException {
        File file;
        String configFileName = System.getProperty("xfire.config");
        InputStreamReader reader = null;
        if (configFileName == null) {
            this.getLogger().info("No configuration file specified.");
            configFileName = "xfire.xml";
        }
        if ((file = new File(configFileName)).exists()) {
            this.getLogger().info("Found configuration file " + file.getAbsolutePath());
            reader = new FileReader(file);
        } else {
            this.getLogger().info("Could not find configuration file " + file.getAbsolutePath());
            this.getLogger().info("Looking in the classpath.");
            InputStream is = this.getClass().getResourceAsStream(configFileName);
            if (is == null && (is = this.getClass().getResourceAsStream("META-INF/xfire/xfire.xml")) == null) {
                return null;
            }
            reader = new InputStreamReader(is);
        }
        return reader;
    }

    public void contextualize(Context context) throws Exception {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void register(Configurator configurator) {
        this.configurators.put(configurator.getServiceType(), configurator);
    }
}

