/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus.java;

import javax.xml.namespace.QName;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.xfire.java.DefaultJavaService;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.java.wsdl.JavaWSDLBuilder;
import org.codehaus.xfire.java.wsdl.WSDLBuilder;
import org.codehaus.xfire.plexus.config.Configurator;
import org.codehaus.xfire.plexus.simple.SimpleConfigurator;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.SimpleService;
import org.codehaus.xfire.transport.TransportManager;

public class JavaConfigurator
extends SimpleConfigurator
implements Configurator {
    public static final String SERVICE_TYPE = "java";

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public Service createService(PlexusConfiguration config) throws Exception {
        DefaultJavaService s = new DefaultJavaService();
        this.configureService(config, s);
        this.getServiceRegistry().register((Service)s);
        return s;
    }

    protected void configureService(PlexusConfiguration config, DefaultJavaService s) throws PlexusConfigurationException {
        super.configureService(config, (SimpleService)s);
        s.setTypeMappingRegistry(this.getTypeMappingRegistry());
        try {
            s.setServiceClass(config.getChild("serviceClass").getValue());
        }
        catch (ClassNotFoundException e) {
            throw new PlexusConfigurationException("Couldn't find service class.", (Throwable)e);
        }
        s.setProperty("allowedMethods", (Object)config.getChild("allowedMethods").getValue(""));
        String scope = config.getChild("scope").getValue("application");
        if (scope.equals("application")) {
            s.setScope(1);
        } else if (scope.equals("session")) {
            s.setScope(2);
        } else if (scope.equals("request")) {
            s.setScope(3);
        }
        s.setAutoTyped(Boolean.valueOf(config.getChild("autoTyped").getValue("false")).booleanValue());
        s.initializeTypeMapping();
        PlexusConfiguration[] types = config.getChild("types").getChildren("type");
        for (int i = 0; i < types.length; ++i) {
            this.initializeType(types[i], s.getTypeMapping());
        }
        s.initializeOperations();
        s.setWSDLBuilder((WSDLBuilder)new JavaWSDLBuilder(this.getTransportManager()));
    }

    private void initializeType(PlexusConfiguration configuration, TypeMapping tm) throws PlexusConfigurationException {
        try {
            String ns = configuration.getAttribute("namespace", tm.getEncodingStyleURI());
            String name = configuration.getAttribute("name");
            tm.register(this.loadClass(configuration.getAttribute("class")), new QName(ns, name), (Type)this.loadClass(configuration.getAttribute("type")).newInstance());
        }
        catch (Exception e) {
            if (e instanceof PlexusConfigurationException) {
                throw (PlexusConfigurationException)e;
            }
            throw new PlexusConfigurationException("Could not configure type.", (Throwable)e);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry registry = null;
        try {
            registry = (TypeMappingRegistry)this.getServiceLocator().lookup(TypeMappingRegistry.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Couldn't find the TypeMappingRegistry!", e);
        }
        return registry;
    }

    protected TransportManager getTransportManager() {
        TransportManager transMan = null;
        try {
            transMan = (TransportManager)this.getServiceLocator().lookup(TransportManager.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Couldn't find the TransportManager!", e);
        }
        return transMan;
    }

    protected Class loadClass(String className) throws Exception {
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return this.getClass().getClassLoader().loadClass(className);
    }
}

