/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus.java;

import javax.xml.namespace.QName;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.xfire.java.mapping.DefaultTypeMappingRegistry;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.type.BooleanType;
import org.codehaus.xfire.java.type.DoubleType;
import org.codehaus.xfire.java.type.FloatType;
import org.codehaus.xfire.java.type.IntType;
import org.codehaus.xfire.java.type.LongType;
import org.codehaus.xfire.java.type.Type;

public class TypeMappingRegistry
extends DefaultTypeMappingRegistry
implements LogEnabled,
Configurable {
    private Logger logger;

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        PlexusConfiguration[] tmConfig = config.getChildren("typeMapping");
        for (int i = 0; i < tmConfig.length; ++i) {
            this.configureTypeMapping(tmConfig[i]);
        }
    }

    private void configureTypeMapping(PlexusConfiguration configuration) throws PlexusConfigurationException {
        TypeMapping tm = this.createTypeMapping(false);
        this.register(configuration.getAttribute("namespace"), tm);
        if (Boolean.valueOf(configuration.getAttribute("default", "false")).booleanValue()) {
            this.registerDefault(tm);
        }
        PlexusConfiguration[] types = configuration.getChildren("type");
        tm.register(Boolean.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "boolean"), (Type)new BooleanType());
        tm.register(Integer.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "int"), (Type)new IntType());
        tm.register(Double.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "double"), (Type)new DoubleType());
        tm.register(Float.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "float"), (Type)new FloatType());
        tm.register(Long.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "long"), (Type)new LongType());
        for (int i = 0; i < types.length; ++i) {
            this.configureType(types[i], tm);
        }
    }

    private void configureType(PlexusConfiguration configuration, TypeMapping tm) throws PlexusConfigurationException {
        try {
            String ns = configuration.getAttribute("namespace");
            String name = configuration.getAttribute("name");
            QName qname = new QName(ns, name);
            Class clazz = this.loadClass(configuration.getAttribute("class"));
            Class typeClass = this.loadClass(configuration.getAttribute("type"));
            tm.register(clazz, qname, (Type)typeClass.newInstance());
            this.logger.debug("Registered " + typeClass.getName() + " for " + qname + " with class " + clazz.getName());
        }
        catch (Exception e) {
            if (e instanceof PlexusConfigurationException) {
                throw (PlexusConfigurationException)e;
            }
            throw new PlexusConfigurationException("Could not configure type.", (Throwable)e);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        try {
            return ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnf2) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
    }
}

