/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmlbeans.client;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.codehaus.xfire.client.AbstractClientHandler;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.xmlbeans.XmlBeansFault;

public class XMLBeansClientHandler
extends AbstractClientHandler {
    private XmlObject[] request;
    private XmlObject[] response;
    private XmlOptions options;

    public XMLBeansClientHandler() {
        this.options = new XmlOptions();
        this.options.setCharacterEncoding("UTF-8");
    }

    public XMLBeansClientHandler(XmlOptions options) {
        this.options = options;
    }

    public XmlObject[] getRequest() {
        return this.request;
    }

    public void setRequest(XmlObject[] request) {
        this.request = request;
    }

    public XmlObject[] getResponse() {
        return this.response;
    }

    public void setResponse(XmlObject[] response) {
        this.response = response;
    }

    public void writeRequest(XMLStreamWriter writer) throws XMLStreamException {
        if (this.request != null) {
            for (int i = 0; i < this.request.length; ++i) {
                STAXUtils.copy((XMLStreamReader)this.request[i].newXMLStreamReader(this.options), (XMLStreamWriter)writer);
            }
        }
    }

    public void handleResponse(XMLStreamReader reader) throws XMLStreamException, XFireFault {
        try {
            ArrayList<XmlObject> responseElements = new ArrayList<XmlObject>();
            boolean more = true;
            int event = reader.getEventType();
            while (more) {
                switch (event) {
                    case 8: {
                        more = false;
                        break;
                    }
                    case 1: {
                        responseElements.add(XmlObject.Factory.parse((XMLStreamReader)reader));
                    }
                    case 2: {
                        if (reader.getLocalName().equals("Envelope")) {
                            more = false;
                            break;
                        }
                        if (!reader.getLocalName().equals("Header")) break;
                        more = false;
                        break;
                    }
                }
                if (!more) continue;
                event = reader.next();
            }
            this.response = responseElements.toArray(new XmlObject[responseElements.size()]);
            XmlCursor cursor = this.response[0].newCursor();
            cursor.toFirstChild();
            if (this.response.length == 1 && cursor.getName().getLocalPart().equals("Fault")) {
                throw new XmlBeansFault(this.response[0]);
            }
        }
        catch (XmlException e) {
            throw new XMLStreamException("Couldn't parse response.", e);
        }
    }
}

