/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmlbeans.generator;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;
import org.xmlsoap.schemas.wsdl.TBinding;
import org.xmlsoap.schemas.wsdl.TBindingOperation;
import org.xmlsoap.schemas.wsdl.TDefinitions;
import org.xmlsoap.schemas.wsdl.TMessage;
import org.xmlsoap.schemas.wsdl.TOperation;
import org.xmlsoap.schemas.wsdl.TParam;
import org.xmlsoap.schemas.wsdl.TPart;
import org.xmlsoap.schemas.wsdl.TPortType;
import org.xmlsoap.schemas.wsdl.TService;
import org.xmlsoap.schemas.wsdl.TTypes;

public class WSDLInspector {
    public static final String schemaNS = "declare namespace xs=\"http://www.w3.org/2001/XMLSchema\"";
    public static final String wsdlNS = "declare namespace wsdl=\"http://schemas.xmlsoap.org/wsdl/\"";
    public static final String wsdlSoapNS = "declare namespace soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"";
    public static final String httpNS = "declare namespace http=\"http://schemas.xmlsoap.org/wsdl/http/";
    SchemaTypeLoader loader = XmlBeans.typeLoaderForClassLoader((ClassLoader)(class$org$apache$xmlbeans$XmlObject == null ? (class$org$apache$xmlbeans$XmlObject = WSDLInspector.class$("org.apache.xmlbeans.XmlObject")) : class$org$apache$xmlbeans$XmlObject).getClassLoader());
    static /* synthetic */ Class class$org$apache$xmlbeans$XmlObject;
    static /* synthetic */ Class class$org$xmlsoap$schemas$wsdl$TDefinitions;

    public List generateServices(URL document) throws Exception {
        EntityResolver entResolver = null;
        XmlOptions options = new XmlOptions();
        options.setLoadLineNumbers();
        options.setEntityResolver(entResolver);
        SchemaTypeLoader wloader = XmlBeans.typeLoaderForClassLoader((ClassLoader)(class$org$xmlsoap$schemas$wsdl$TDefinitions == null ? (class$org$xmlsoap$schemas$wsdl$TDefinitions = WSDLInspector.class$("org.xmlsoap.schemas.wsdl.TDefinitions")) : class$org$xmlsoap$schemas$wsdl$TDefinitions).getClassLoader());
        XmlObject wsdldoc = wloader.parse(document, null, options);
        TDefinitions defs = ((DefinitionsDocument)wsdldoc).getDefinitions();
        TTypes[] types = defs.getTypesArray();
        ArrayList<Service> services = new ArrayList<Service>();
        TService[] xServices = defs.getServiceArray();
        for (int i = 0; i < xServices.length; ++i) {
            TService xService = xServices[i];
            Service service = new Service();
            XmlObject[] xAddresses = xService.selectPath("declare namespace soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" $this//soap:address");
            if (xAddresses == null || xAddresses.length == 0) {
                xAddresses = xService.selectPath("declare namespace http=\"http://schemas.xmlsoap.org/wsdl/http/ $this//http:address");
                if (xAddresses == null || xAddresses.length == 0) break;
                service.setRest(true);
                break;
            }
            service.setName(xService.getName());
            service.setUrl(xAddresses[0].selectAttribute("", "location").newCursor().getTextValue());
            service.setXmlObject(xService);
            service.setBinding(xService.getPortArray(0).getBinding());
            TBinding xBinding = this.getBinding(defs, service.getBinding());
            if (xBinding == null) {
                throw new RuntimeException("Couldn't find binding!");
            }
            service.setPortType(xBinding.getType());
            TPortType xPortType = this.getPortType(defs, service.getPortType());
            if (xPortType == null) {
                throw new RuntimeException("Couldn't find port type!");
            }
            TBindingOperation[] xOperations = xBinding.getOperationArray();
            for (int j = 0; j < xOperations.length; ++j) {
                ServiceMethod m = this.createMethod(xOperations[j], xPortType, defs);
                service.addMethod(m);
            }
            services.add(service);
        }
        return services;
    }

    private ServiceMethod createMethod(TBindingOperation xOperation, TPortType portType, TDefinitions defs) {
        Node actionNode;
        XmlObject[] soapOp;
        int i;
        ServiceMethod m = new ServiceMethod();
        m.setName(xOperation.getName());
        TOperation abstractOp = this.getAbstractOperation(m.getName(), portType);
        TParam input = abstractOp.getInput();
        TMessage message = this.getMessage(input.getMessage().getLocalPart(), defs);
        TPart[] xParts = message.getPartArray();
        for (int i2 = 0; i2 < xParts.length; ++i2) {
            Parameter p = new Parameter();
            p.setName(xParts[i2].getName());
            SchemaType type = this.loader.findDocumentType(xParts[i2].getElement());
            if (type == null) {
                System.out.println("Couldn't find type " + xParts[i2].getElement().toString());
                type = XmlAnySimpleType.type;
            }
            p.setType(type);
            m.addRequestParameter(p);
        }
        XmlObject[] xHeaders = xOperation.getInput().selectPath("declare namespace soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" $this//soap:header");
        if (xHeaders != null) {
            QName partQ = new QName("part");
            QName messageQ = new QName("message");
            for (i = 0; i < xHeaders.length; ++i) {
                String msgName = xHeaders[i].newCursor().getAttributeText(messageQ);
                msgName = msgName.substring(msgName.indexOf(":") + 1);
                String partName = xHeaders[i].newCursor().getAttributeText(partQ);
                TMessage hMessage = this.getMessage(msgName, defs);
                TPart part = this.getPart(hMessage, partName);
                Parameter p = new Parameter();
                p.setName(part.getName() + "Header");
                SchemaType type = this.loader.findDocumentType(part.getElement());
                if (type == null) {
                    System.out.println("Couldn't find type " + xParts[i].getElement().toString());
                    type = XmlAnySimpleType.type;
                }
                p.setType(type);
                m.addRequestHeader(p);
            }
        }
        if ((soapOp = xOperation.selectPath("declare namespace soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" $this//soap:operation")) != null && soapOp.length > 0 && (actionNode = soapOp[0].getDomNode().getAttributes().getNamedItem("soapAction")) != null) {
            m.setSoapAction(actionNode.getNodeValue());
        }
        TParam output = abstractOp.getOutput();
        message = this.getMessage(output.getMessage().getLocalPart(), defs);
        xParts = message.getPartArray();
        for (i = 0; i < xParts.length; ++i) {
            Parameter p = new Parameter();
            p.setName(xParts[i].getName());
            p.setType(this.loader.findDocumentType(xParts[i].getElement()));
            m.addResponseParameter(p);
        }
        return m;
    }

    private TPart getPart(TMessage message, String partName) {
        TPart[] parts = message.getPartArray();
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].getName().equals(partName)) continue;
            return parts[i];
        }
        return null;
    }

    private TMessage getMessage(String name, TDefinitions defs) {
        TMessage[] xMessages = defs.getMessageArray();
        for (int i = 0; i < xMessages.length; ++i) {
            if (!xMessages[i].getName().equals(name)) continue;
            return xMessages[i];
        }
        return null;
    }

    private TOperation getAbstractOperation(String name, TPortType portType) {
        TOperation[] xOperations = portType.getOperationArray();
        for (int j = 0; j < xOperations.length; ++j) {
            if (!xOperations[j].getName().equals(name)) continue;
            return xOperations[j];
        }
        return null;
    }

    private TPortType getPortType(TDefinitions defs, QName portType) {
        TPortType[] portTypes = defs.getPortTypeArray();
        for (int i = 0; i < portTypes.length; ++i) {
            if (!portTypes[i].getName().equals(portType.getLocalPart())) continue;
            return portTypes[i];
        }
        return null;
    }

    private TBinding getBinding(TDefinitions defs, QName binding) {
        TBinding[] bindings = defs.getBindingArray();
        for (int i = 0; i < bindings.length; ++i) {
            if (!bindings[i].getName().equals(binding.getLocalPart())) continue;
            return bindings[i];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Parameter {
        private SchemaType type;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SchemaType getType() {
            return this.type;
        }

        public void setType(SchemaType type) {
            this.type = type;
        }
    }

    public class ServiceMethod {
        private String soapAction;
        private String name;
        private List requestParameters;
        private List responseParameters;
        private List requestHeaders;
        private List responseHeaders;
        private XmlObject xmlObject;

        public void addRequestParameter(Parameter parameter) {
            if (this.requestParameters == null) {
                this.requestParameters = new ArrayList();
            }
            this.requestParameters.add(parameter);
        }

        public void addResponseParameter(Parameter parameter) {
            if (this.responseParameters == null) {
                this.responseParameters = new ArrayList();
            }
            this.responseParameters.add(parameter);
        }

        public void addRequestHeader(Parameter parameter) {
            if (this.requestHeaders == null) {
                this.requestHeaders = new ArrayList();
            }
            this.requestHeaders.add(parameter);
        }

        public void addResponseHeader(Parameter parameter) {
            if (this.responseHeaders == null) {
                this.responseHeaders = new ArrayList();
            }
            this.responseHeaders.add(parameter);
        }

        public List getRequestParameters() {
            return this.requestParameters;
        }

        public void setRequestParameters(List requestParameters) {
            this.requestParameters = requestParameters;
        }

        public List getResponseParameters() {
            return this.responseParameters;
        }

        public void setResponseParameters(List responseParameters) {
            this.responseParameters = responseParameters;
        }

        public List getRequestHeaders() {
            return this.requestHeaders;
        }

        public void setRequestHeaders(List requestHeaders) {
            this.requestHeaders = requestHeaders;
        }

        public List getResponseHeaders() {
            return this.responseHeaders;
        }

        public void setResponseHeaders(List responseHeaders) {
            this.responseHeaders = responseHeaders;
        }

        public String getSoapAction() {
            return this.soapAction;
        }

        public XmlObject getXmlObject() {
            return this.xmlObject;
        }

        public void setXmlObject(XmlObject xmlObject) {
            this.xmlObject = xmlObject;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSoapAction(String soapAction) {
            this.soapAction = soapAction;
        }
    }

    public class Service {
        private String name;
        private String url;
        private List methods;
        private String encoding = "UTF-8";
        private XmlObject xmlObject;
        private QName binding;
        private QName portType;
        private boolean isRest;
        private String soapVersion;

        public Set getImports() {
            HashSet<SchemaType> imports = new HashSet<SchemaType>();
            if (this.methods != null) {
                Iterator itr = this.methods.iterator();
                while (itr.hasNext()) {
                    Parameter p;
                    Iterator pitr;
                    ServiceMethod m = (ServiceMethod)itr.next();
                    if (m.getRequestParameters() != null) {
                        pitr = m.getRequestParameters().iterator();
                        while (pitr.hasNext()) {
                            p = (Parameter)pitr.next();
                            imports.add(p.getType());
                        }
                    }
                    if (m.getResponseParameters() != null) {
                        pitr = m.getResponseParameters().iterator();
                        while (pitr.hasNext()) {
                            p = (Parameter)pitr.next();
                            imports.add(p.getType());
                        }
                    }
                    if (m.getRequestHeaders() == null) continue;
                    pitr = m.getRequestHeaders().iterator();
                    while (pitr.hasNext()) {
                        p = (Parameter)pitr.next();
                        imports.add(p.getType());
                    }
                }
            }
            return imports;
        }

        public String getSoapVersion() {
            return this.soapVersion;
        }

        public void setSoapVersion(String soapVersion) {
            this.soapVersion = soapVersion;
        }

        public boolean isRest() {
            return this.isRest;
        }

        public void setRest(boolean isRest) {
            this.isRest = isRest;
        }

        public QName getPortType() {
            return this.portType;
        }

        public void setPortType(QName portType) {
            this.portType = portType;
        }

        public QName getBinding() {
            return this.binding;
        }

        public void setBinding(QName binding) {
            this.binding = binding;
        }

        public XmlObject getXmlObject() {
            return this.xmlObject;
        }

        public void setXmlObject(XmlObject xmlObject) {
            this.xmlObject = xmlObject;
        }

        public void addMethod(ServiceMethod m) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(m);
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public List getMethods() {
            return this.methods;
        }

        public void setMethods(List methods) {
            this.methods = methods;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

