/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.JConstructor;
import org.apache.xmlbeans.impl.jam.JField;
import org.apache.xmlbeans.impl.jam.JMethod;
import org.apache.xmlbeans.impl.jam.JParameter;

public class ReflectionUtils {
    private static final ReflectionUtils INSTANCE = new ReflectionUtils();

    public static final ReflectionUtils getInstance() {
        return INSTANCE;
    }

    private ReflectionUtils() {
    }

    public Method getMethodOn(JMethod method, Class containedin) throws NoSuchMethodException, ClassNotFoundException {
        if (containedin == null) {
            throw new IllegalArgumentException("null class");
        }
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        Class[] types = null;
        JParameter[] params = method.getParameters();
        if (params != null && params.length > 0) {
            types = new Class[params.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = this.loadClass(params[i].getType(), containedin.getClassLoader());
            }
        }
        return containedin.getMethod(method.getSimpleName(), types);
    }

    public Constructor getConstructorOn(JConstructor ctor, Class containedin) throws NoSuchMethodException, ClassNotFoundException {
        if (containedin == null) {
            throw new IllegalArgumentException("null class");
        }
        if (ctor == null) {
            throw new IllegalArgumentException("null ctor");
        }
        Class[] types = null;
        JParameter[] params = ctor.getParameters();
        if (params != null && params.length > 0) {
            types = new Class[params.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = this.loadClass(params[i].getType(), containedin.getClassLoader());
            }
        }
        return containedin.getConstructor(types);
    }

    public Field getFieldOn(JField field, Class containedin) throws NoSuchFieldException {
        if (containedin == null) {
            throw new IllegalArgumentException("null class");
        }
        if (field == null) {
            throw new IllegalArgumentException("null field");
        }
        Object types = null;
        return containedin.getField(field.getSimpleName());
    }

    public Class loadClass(JClass clazz, ClassLoader inThisClassloader) throws ClassNotFoundException {
        return inThisClassloader.loadClass(clazz.getQualifiedName());
    }
}

