/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annogen.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoProxy;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoProxySet;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoType;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoTypeRegistry;
import org.apache.xmlbeans.impl.jam.annogen.provider.ProviderContext;
import org.apache.xmlbeans.impl.jam.provider.JamLogger;

public class AnnoProxySetImpl
implements AnnoProxySet {
    private Map mAt2Ap = new HashMap();
    private AnnoTypeRegistry mTypeRegistry;
    private JamLogger mLogger;

    public AnnoProxySetImpl(ProviderContext ctx) {
        this.mTypeRegistry = ctx.getAnnoTypeRegistry();
        this.mLogger = ctx.getLogger();
    }

    public boolean containsProxyFor(Class requestedClass) {
        AnnoType annoType = this.getAnnoType(requestedClass);
        if (annoType == null) {
            return false;
        }
        return this.mAt2Ap.containsKey(annoType);
    }

    public AnnoProxy findOrCreateProxyFor(Class requestedClass) {
        AnnoType annoType = this.getAnnoType(requestedClass);
        if (annoType == null) {
            return null;
        }
        AnnoProxy ap = (AnnoProxy)this.mAt2Ap.get(annoType);
        if (ap != null) {
            return ap;
        }
        return this.createProxyInstance(annoType);
    }

    public AnnoProxy removeProxyFor(Class requestedClass) {
        AnnoType annoType = this.getAnnoType(requestedClass);
        if (annoType == null) {
            return null;
        }
        return (AnnoProxy)this.mAt2Ap.remove(annoType);
    }

    public AnnoProxy[] getAnnoProxies() {
        AnnoProxy[] out = new AnnoProxy[this.mAt2Ap.values().size()];
        this.mAt2Ap.values().toArray(out);
        return out;
    }

    private AnnoType getAnnoType(Class requestedClass) {
        try {
            return this.mTypeRegistry.getAnnoTypeForRequestedClass(requestedClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.mLogger.error(cnfe);
            return null;
        }
    }

    private AnnoProxy createProxyInstance(AnnoType at) {
        try {
            return (AnnoProxy)at.getProxyClass().newInstance();
        }
        catch (InstantiationException e) {
            this.mLogger.error(e);
        }
        catch (IllegalAccessException e) {
            this.mLogger.error(e);
        }
        return null;
    }
}

