/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annogen.internal;

import org.apache.xmlbeans.impl.jam.annogen.internal.AnnoProxySetImpl;
import org.apache.xmlbeans.impl.jam.annogen.internal.AnnoServiceParamsImpl;
import org.apache.xmlbeans.impl.jam.annogen.internal.CompositeAnnoModifier;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoModifier;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoProxy;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoProxySet;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoType;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoTypeRegistry;
import org.apache.xmlbeans.impl.jam.annogen.provider.ElementId;
import org.apache.xmlbeans.impl.jam.annogen.provider.ProviderContext;
import org.apache.xmlbeans.impl.jam.provider.JamLogger;

public abstract class AnnoServiceBase {
    private ProviderContext mContext;
    private AnnoTypeRegistry mRegistry;
    private AnnoModifier mModifier;
    private JamLogger mLogger;

    public AnnoServiceBase(AnnoServiceParamsImpl asp) {
        if (asp == null) {
            throw new IllegalArgumentException("null asp");
        }
        AnnoModifier[] pps = asp.getPopulators();
        this.mModifier = pps.length == 1 ? pps[0] : new CompositeAnnoModifier(pps);
        this.mModifier.init(asp);
        this.mRegistry = asp.getAnnoTypeRegistry();
        this.mLogger = asp.getLogger();
        this.mContext = asp;
    }

    protected abstract void getIndigenousAnnotations(ElementId var1, AnnoProxySet var2);

    protected AnnoProxy[] getAnnotations(ElementId id) {
        AnnoProxySetImpl apsi = new AnnoProxySetImpl(this.mContext);
        this.getIndigenousAnnotations(id, apsi);
        this.mModifier.modifyAnnos(id, apsi);
        return apsi.getAnnoProxies();
    }

    protected AnnoProxy getAnnotation(Class what, ElementId where) {
        AnnoType whatType;
        try {
            whatType = this.mRegistry.getAnnoTypeForRequestedClass(what);
        }
        catch (ClassNotFoundException cnfe) {
            this.mLogger.error(cnfe);
            return null;
        }
        Class proxyClass = whatType.getProxyClass();
        AnnoProxy[] annos = this.getAnnotations(where);
        for (int i = 0; i < annos.length; ++i) {
            if (!proxyClass.isAssignableFrom(annos[i].getClass())) continue;
            return annos[i];
        }
        return null;
    }
}

