/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annogen.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoProxy;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoType;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoTypeRegistry;

public class DefaultAnnoTypeRegistry
implements AnnoTypeRegistry {
    public static final String SUB_PACKAGE = "impl";
    public static final String CLASSNAME_SUFFIX = "Impl";
    private Map mDeclaredClass2AT = new HashMap();
    private Map mProxyClass2AT = new HashMap();

    public AnnoType getAnnoTypeForRequestedClass(Class requestedClass) throws ClassNotFoundException {
        if (AnnoProxy.class.isAssignableFrom(requestedClass)) {
            return this.getAnnoTypeForProxyType(requestedClass);
        }
        AnnoType out = this.getAnnoTypeForDeclaredType(requestedClass);
        if (!out.getDeclaredClass().isAssignableFrom(out.getProxyClass())) {
            throw new ClassNotFoundException("The proxy for the requested annotation type '" + out.getDeclaredClass() + " does not implement the annotation " + "interface.  This is probably because it was compiled in " + "1.4-safe mode.  To access this annotation, please request " + "the proxy type: '" + out.getProxyClass() + "'");
        }
        return out;
    }

    public AnnoType getAnnoTypeForDeclaredType(Class declaredType) throws ClassNotFoundException {
        AnnoType out = (AnnoType)this.mDeclaredClass2AT.get(declaredType);
        if (out != null) {
            return out;
        }
        String declaredName = declaredType.getName();
        int lastDot = declaredName.lastIndexOf(46);
        String pkg = declaredName.substring(0, lastDot + 1);
        String clazz = declaredName.substring(lastDot + 1);
        Class<?> proxyType = declaredType.getClassLoader().loadClass(pkg + SUB_PACKAGE + "." + clazz + CLASSNAME_SUFFIX);
        out = new AnnoType(declaredType, proxyType);
        this.addToCache(out);
        return out;
    }

    public AnnoType getAnnoTypeForProxyType(Class proxyClass) throws ClassNotFoundException {
        AnnoType out = (AnnoType)this.mProxyClass2AT.get(proxyClass);
        if (out != null) {
            return out;
        }
        String pkg = proxyClass.getPackage().getName();
        pkg = pkg.substring(0, pkg.length() - 4);
        String name = DefaultAnnoTypeRegistry.getShortName(proxyClass);
        name = name.substring(0, name.length() - 4);
        Class<?> declClass = proxyClass.getClassLoader().loadClass(pkg + name);
        out = new AnnoType(declClass, proxyClass);
        this.addToCache(out);
        return out;
    }

    private static String getShortName(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    private void addToCache(AnnoType at) {
        this.mDeclaredClass2AT.put(at.getDeclaredClass(), at);
        this.mProxyClass2AT.put(at.getProxyClass(), at);
    }
}

