/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annogen.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.xmlbeans.impl.jam.annogen.ReflectAnnoService;
import org.apache.xmlbeans.impl.jam.annogen.internal.AnnoServiceBase;
import org.apache.xmlbeans.impl.jam.annogen.internal.AnnoServiceParamsImpl;
import org.apache.xmlbeans.impl.jam.annogen.internal.ElementIdPool;
import org.apache.xmlbeans.impl.jam.annogen.internal.ReflectElementId;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoProxy;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoProxySet;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoType;
import org.apache.xmlbeans.impl.jam.annogen.provider.AnnoTypeRegistry;
import org.apache.xmlbeans.impl.jam.annogen.provider.ElementId;
import org.apache.xmlbeans.impl.jam.internal.reflect.Reflect15Delegate;
import org.apache.xmlbeans.impl.jam.provider.JamLogger;

public class ReflectAnnoServiceImpl
extends AnnoServiceBase
implements ReflectAnnoService {
    private ElementIdPool mIdPool = ElementIdPool.getInstance();
    private Reflect15Delegate mDelegate = null;
    private JamLogger mLogger;
    private AnnoTypeRegistry mRegistry;
    static /* synthetic */ Class class$java$lang$Object;

    public ReflectAnnoServiceImpl(AnnoServiceParamsImpl asp) {
        super(asp);
        this.mLogger = asp.getLogger();
        this.mDelegate = Reflect15Delegate.Factory.create(this.mLogger);
        this.mRegistry = asp.getAnnoTypeRegistry();
    }

    protected void getIndigenousAnnotations(ElementId id, AnnoProxySet out) {
        if (this.mDelegate == null) {
            return;
        }
        Object[] raw = this.getRawAnnotations(id);
        for (int i = 0; i < raw.length; ++i) {
            AnnoType at;
            Class declClass = this.mDelegate.getAnnotationClassFor(raw[i]);
            try {
                at = this.mRegistry.getAnnoTypeForDeclaredType(declClass);
            }
            catch (ClassNotFoundException cnfe) {
                this.mLogger.error(cnfe);
                continue;
            }
            AnnoProxy proxy = out.findOrCreateProxyFor(declClass);
            this.copyValues(raw[i], proxy, at);
        }
    }

    public Object getAnnotation(Class requestedAnnoClass, Package pakkage) {
        return super.getAnnotation(requestedAnnoClass, this.mIdPool.getIdFor(pakkage));
    }

    public Object getAnnotation(Class annoClass, Class clazz) {
        return super.getAnnotation(annoClass, this.mIdPool.getIdFor(clazz));
    }

    public Object getAnnotation(Class requestedAnnoClass, Constructor ctor) {
        return super.getAnnotation(requestedAnnoClass, this.mIdPool.getIdFor(ctor));
    }

    public Object getAnnotation(Class requestedAnnoClass, Constructor ctor, int pnum) {
        return super.getAnnotation(requestedAnnoClass, this.mIdPool.getIdFor(ctor, pnum));
    }

    public Object getAnnotation(Class requestedAnnoClass, Field field) {
        return super.getAnnotation(requestedAnnoClass, this.mIdPool.getIdFor(field));
    }

    public Object getAnnotation(Class requestedAnnoClass, Method method) {
        return super.getAnnotation(requestedAnnoClass, this.mIdPool.getIdFor(method));
    }

    public Object getAnnotation(Class requestedAnnoClass, Method method, int pnum) {
        return super.getAnnotation(requestedAnnoClass, this.mIdPool.getIdFor(method, pnum));
    }

    public Object[] getAnnotations(Package pakkage) {
        return super.getAnnotations(this.mIdPool.getIdFor(pakkage));
    }

    public Object[] getAnnotations(Class clazz) {
        return super.getAnnotations(this.mIdPool.getIdFor(clazz));
    }

    public Object[] getAnnotations(Field field) {
        return super.getAnnotations(this.mIdPool.getIdFor(field));
    }

    public Object[] getAnnotations(Constructor ctor) {
        return super.getAnnotations(this.mIdPool.getIdFor(ctor));
    }

    public Object[] getAnnotations(Method field) {
        return super.getAnnotations(this.mIdPool.getIdFor(field));
    }

    public Object[] getAnnotations(Constructor ctor, int paramNum) {
        return super.getAnnotations(this.mIdPool.getIdFor(ctor, paramNum));
    }

    public Object[] getAnnotations(Method method, int paramNum) {
        return super.getAnnotations(this.mIdPool.getIdFor(method, paramNum));
    }

    private Object[] getRawAnnotations(ElementId id) {
        if (!(id instanceof ReflectElementId)) {
            throw new IllegalStateException();
        }
        Object ae = ((ReflectElementId)id).getAnnotatedElement();
        switch (id.getType()) {
            case 0: {
                return this.mDelegate.getAnnotations((Package)ae);
            }
            case 1: {
                return this.mDelegate.getAnnotations((Class)ae);
            }
            case 3: {
                return this.mDelegate.getAnnotations((Method)ae);
            }
            case 4: {
                return this.mDelegate.getAnnotations((Constructor)ae);
            }
            case 2: {
                return this.mDelegate.getAnnotations((Field)ae);
            }
            case 5: {
                if (ae instanceof Method) {
                    return this.mDelegate.getAnnotations((Method)ae, id.getParameterNumber());
                }
                return this.mDelegate.getAnnotations((Constructor)ae, id.getParameterNumber());
            }
        }
        throw new IllegalStateException("id.getType() == " + id.getType());
    }

    private void copyValues(Object src, AnnoProxy dest, AnnoType destType) {
        boolean isVerbose = false;
        if (src == null) {
            throw new IllegalArgumentException();
        }
        Class annType = destType.getDeclaredClass();
        if (isVerbose) {
            this.mLogger.verbose("type is " + annType.getName());
        }
        Method[] methods = annType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Object value;
            Class<?> c;
            int mods;
            if (isVerbose) {
                this.mLogger.verbose("examining " + methods[i].toString());
            }
            if (Modifier.isStatic(mods = methods[i].getModifiers()) || !Modifier.isPublic(mods) || methods[i].getParameterTypes().length > 0) continue;
            if ((class$java$lang$Object == null ? ReflectAnnoServiceImpl.class$("java.lang.Object") : class$java$lang$Object).equals(c = methods[i].getDeclaringClass())) continue;
            if (isVerbose) {
                this.mLogger.verbose("invoking " + methods[i].getName() + "()");
            }
            try {
                value = methods[i].invoke(src, (Object[])null);
            }
            catch (IllegalAccessException e) {
                this.mLogger.error(e);
                continue;
            }
            catch (InvocationTargetException e) {
                this.mLogger.error(e);
                continue;
            }
            if (isVerbose) {
                this.mLogger.verbose("value is " + value);
            }
            Class<?> valClass = value.getClass();
            try {
                if (!this.isSimpleType(valClass)) {
                    if (valClass.isArray()) {
                        if (this.isSimpleType(valClass.getComponentType())) {
                            // empty if block
                        }
                        throw new IllegalArgumentException("array annotation properties NYI");
                    }
                    throw new IllegalArgumentException("complex annotation properties NYI");
                }
                dest.setValue(methods[i].getName(), value);
                continue;
            }
            catch (Exception fixme) {
                this.mLogger.error(fixme);
            }
        }
    }

    private boolean isSimpleType(Class c) {
        return c.isPrimitive() || c.getName().equals("java.lang.String");
    }
}

