/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annogen.internal.joust;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.CodeGenUtil;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.FileWriterFactory;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.SourceJavaOutputStream;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.WriterFactory;

public class CompilingJavaOutputStream
extends SourceJavaOutputStream
implements WriterFactory {
    private static final String PREFIX = "[CompilingJavaOutputStream] ";
    private FileWriterFactory mWriterFactoryDelegate;
    private List mSourceFiles;
    private File mSourceDir = null;
    private File mCompileDir = null;
    private File[] mJavacClasspath = null;
    private boolean mKeepGenerated;
    private String mJavacPath = null;
    private boolean mDoCompile = true;

    public CompilingJavaOutputStream(File srcDir) {
        this();
        this.setSourceDir(srcDir);
    }

    public CompilingJavaOutputStream() {
        this.setWriterFactory(this);
        this.mSourceFiles = new ArrayList();
    }

    public void setSourceDir(File srcDir) {
        if (srcDir == null) {
            throw new IllegalArgumentException("null srcDir");
        }
        this.mSourceDir = srcDir;
        this.mWriterFactoryDelegate = new FileWriterFactory(this.mSourceDir);
    }

    public void setCompilationDir(File destDir) {
        this.mCompileDir = destDir;
    }

    public void setJavac(String javacPath) {
        this.mJavacPath = javacPath;
    }

    public void setJavacClasspath(File[] classpath) {
        this.mJavacClasspath = classpath;
    }

    public void setKeepGenerated(boolean b) {
        this.mKeepGenerated = b;
    }

    public void setDoCompile(boolean b) {
        this.mDoCompile = b;
    }

    public Writer createWriter(String packageName, String className) throws IOException {
        if (this.mWriterFactoryDelegate == null) {
            throw new IllegalStateException("delegate never set called on the CompilingJavaOutputStream");
        }
        File out = this.mWriterFactoryDelegate.createFile(packageName, className);
        this.mSourceFiles.add(out);
        return new FileWriter(out);
    }

    public void close() throws IOException {
        super.close();
        this.mLogger.verbose("[CompilingJavaOutputStream]  closing");
        if (this.mDoCompile && this.mCompileDir != null) {
            this.mLogger.verbose("[CompilingJavaOutputStream] compileDir = " + this.mCompileDir);
            Iterator i = this.mSourceFiles.iterator();
            while (i.hasNext()) {
                this.mLogger.verbose(PREFIX + i.next().toString());
            }
            boolean verbose = this.mLogger.isVerbose();
            boolean result = this.mSourceFiles.size() > 0 ? CodeGenUtil.externalCompile(this.mSourceFiles, this.mCompileDir, this.mJavacClasspath, verbose, this.mJavacPath, null, null, !verbose, verbose) : true;
            this.mLogger.verbose("[CompilingJavaOutputStream]  compilation result: " + result);
            if (!result) {
                throw new IOException("Compilation of sources failed, check log for details.");
            }
            if (!this.mKeepGenerated) {
                this.mLogger.verbose("[CompilingJavaOutputStream]  deleting " + this.mSourceDir);
                this.mSourceDir.delete();
            }
        }
    }
}

