/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annogen.tools;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.JMethod;
import org.apache.xmlbeans.impl.jam.JamService;
import org.apache.xmlbeans.impl.jam.JamServiceFactory;
import org.apache.xmlbeans.impl.jam.JamServiceParams;
import org.apache.xmlbeans.impl.jam.annogen.internal.AnnoProxyBase;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.FileWriterFactory;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.JavaOutputStream;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.SourceJavaOutputStream;
import org.apache.xmlbeans.impl.jam.annogen.internal.joust.Variable;

public class Annogen {
    public static final String SETTER_PREFIX = "set_";
    private static final String FIELD_PREFIX = "_";
    private static final String IMPL_SUFFIX = "Impl";
    private static final String BASE_CLASS = AnnoProxyBase.class.getName();
    private List mClassesTodo = new LinkedList();
    private Collection mClassesDone = new HashSet();
    private JavaOutputStream mJoust = null;
    private boolean m14Compatible = true;

    public static void main(String[] args) {
        try {
            JamServiceFactory jsf = JamServiceFactory.getInstance();
            JamServiceParams params = jsf.createServiceParams();
            Annogen ag = new Annogen();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-d")) {
                    ag.setOutputDir(new File(args[++i]));
                    ++i;
                    continue;
                }
                File f = new File(args[i]);
                if (f.isDirectory()) {
                    File[] fs = f.listFiles();
                    for (int j = 0; j < fs.length; ++j) {
                        params.includeSourceFile(fs[j]);
                    }
                    continue;
                }
                params.includeSourceFile(f);
            }
            JamService js = jsf.createService(params);
            ag.addAnnotationClasses(js.getAllClasses());
            ag.doCodegen();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.flush();
            System.exit(-1);
        }
    }

    public void addAnnotationClasses(JClass[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            this.mClassesTodo.addAll(Arrays.asList(classes));
        }
    }

    public void setOutputDir(File dir) {
        FileWriterFactory wf = new FileWriterFactory(dir);
        this.setJavaOutputStream(new SourceJavaOutputStream(wf));
    }

    public void setJavaOutputStream(JavaOutputStream joust) {
        this.mJoust = joust;
    }

    public void doCodegen() throws IOException {
        while (this.mClassesTodo.size() > 0) {
            JClass clazz = (JClass)this.mClassesTodo.get(0);
            this.mClassesTodo.remove(0);
            this.mClassesDone.add(clazz);
            this.doCodegen(clazz);
        }
    }

    public void setPre15CompatibilityMode(boolean b) {
        this.m14Compatible = b;
    }

    private void doCodegen(JClass clazz) throws IOException {
        String[] stringArray;
        JMethod[] methods = clazz.getDeclaredMethods();
        String simpleImplName = Annogen.getImplSimpleClassnameFor(clazz);
        this.mJoust.startFile(this.getPackageFor(clazz), simpleImplName);
        if (this.m14Compatible) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = clazz.getQualifiedName();
        }
        String[] implementInterface = stringArray;
        this.mJoust.startClass(1, BASE_CLASS, implementInterface);
        for (int i = 0; i < methods.length; ++i) {
            String fieldName = FIELD_PREFIX + methods[i].getSimpleName();
            JClass type = methods[i].getReturnType();
            String typeName = this.m14Compatible ? this.getImplClassForIfGenerated(type) : type.getQualifiedName();
            Variable fieldVar = this.mJoust.writeField(2, typeName, fieldName, null);
            this.mJoust.startMethod(1, typeName, methods[i].getSimpleName(), null, null, null);
            this.mJoust.writeReturnStatement(fieldVar);
            this.mJoust.endMethodOrConstructor();
            String[] paramTypeNames = new String[]{typeName};
            String[] paramNames = new String[]{"in"};
            Variable[] params = this.mJoust.startMethod(1, "void", SETTER_PREFIX + methods[i].getSimpleName(), paramTypeNames, paramNames, null);
            this.mJoust.writeAssignmentStatement(fieldVar, params[0]);
            this.mJoust.endMethodOrConstructor();
            JClass c = clazz.forName(typeName);
            if (!c.isAnnotationType() || this.mClassesTodo.contains(c) || this.mClassesDone.contains(c)) continue;
            this.mClassesTodo.add(c);
        }
        this.mJoust.endClassOrInterface();
        this.mJoust.endFile();
    }

    private void warn(String msg) {
        System.out.println("[Warning] " + msg);
    }

    private String getImplClassForIfGenerated(JClass clazz) {
        if (clazz.isArrayType()) {
            JClass comp = clazz.getArrayComponentType();
            if (this.mClassesTodo.contains(comp) || this.mClassesDone.contains(comp)) {
                StringWriter out = new StringWriter();
                out.write(Annogen.getImplClassFor(comp));
                for (int i = 0; i < comp.getArrayDimensions(); ++i) {
                    out.write("[]");
                }
                return out.toString();
            }
        } else if (this.mClassesTodo.contains(clazz) || this.mClassesDone.contains(clazz)) {
            return Annogen.getImplClassFor(clazz);
        }
        return clazz.getQualifiedName();
    }

    private String getPackageFor(JClass clazz) {
        return clazz.getContainingPackage().getQualifiedName() + ".impl";
    }

    private static String getImplSimpleClassnameFor(JClass clazz) {
        return clazz.getSimpleName() + IMPL_SUFFIX;
    }

    public static String getImplClassFor(Class clazz) {
        String shortName = clazz.getName();
        shortName = shortName.substring(shortName.lastIndexOf(46) + 1);
        return clazz.getPackage().getName() + ".impl." + shortName + IMPL_SUFFIX;
    }

    private static String getImplClassFor(JClass clazz) {
        String shortName = clazz.getQualifiedName();
        shortName = shortName.substring(shortName.lastIndexOf(46) + 1);
        return clazz.getContainingPackage().getQualifiedName() + ".impl." + shortName + IMPL_SUFFIX;
    }
}

