/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annogen.tools;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.JamService;
import org.apache.xmlbeans.impl.jam.JamServiceFactory;
import org.apache.xmlbeans.impl.jam.JamServiceParams;
import org.apache.xmlbeans.impl.jam.annogen.tools.Annogen;

public class AnnogenTask
extends Task {
    private Annogen mAnnogen = new Annogen();
    private Path mSrcDir = null;
    private Path mToolpath = null;
    private Path mClasspath = null;
    private String mIncludes = "**/*.java";

    public void setOutputDir(File f) {
        this.mAnnogen.setOutputDir(f);
    }

    public void setSrcdir(Path srcDir) {
        if (this.mSrcDir == null) {
            this.mSrcDir = srcDir;
        } else {
            this.mSrcDir.append(srcDir);
        }
    }

    public void setIncludes(String includes) {
        if (includes == null) {
            throw new IllegalArgumentException("null includes");
        }
        this.mIncludes = includes;
    }

    public void setPre15CompatibilityMode(boolean b) {
        this.mAnnogen.setPre15CompatibilityMode(b);
    }

    public void setToolpath(Path path) {
        if (this.mToolpath == null) {
            this.mToolpath = path;
        } else {
            this.mToolpath.append(path);
        }
    }

    public void setToolpathRef(Reference r) {
        this.createToolpath().setRefid(r);
    }

    public Path createToolpath() {
        if (this.mToolpath == null) {
            this.mToolpath = new Path(this.getProject());
        }
        return this.mToolpath.createPath();
    }

    public void setClasspath(Path path) {
        if (this.mClasspath == null) {
            this.mClasspath = path;
        } else {
            this.mClasspath.append(path);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.mClasspath == null) {
            this.mClasspath = new Path(this.getProject());
        }
        return this.mClasspath.createPath();
    }

    public void execute() throws BuildException {
        int i;
        if (this.mSrcDir == null) {
            throw new BuildException("'srcDir' must be specified");
        }
        JamServiceFactory jsf = JamServiceFactory.getInstance();
        JamServiceParams p = jsf.createServiceParams();
        if (this.mToolpath != null) {
            File[] tcp = this.path2files(this.mToolpath);
            for (i = 0; i < tcp.length; ++i) {
                p.addToolClasspath(tcp[i]);
            }
        }
        if (this.mClasspath != null) {
            File[] cp = this.path2files(this.mClasspath);
            for (i = 0; i < cp.length; ++i) {
                p.addClasspath(cp[i]);
            }
        }
        p.includeSourcePattern(this.path2files(this.mSrcDir), this.mIncludes);
        try {
            JamService js = jsf.createService(p);
            JClass[] classes = js.getAllClasses();
            this.mAnnogen.addAnnotationClasses(classes);
            this.log("Generating annotation impls for the following classes:");
            for (int i2 = 0; i2 < classes.length; ++i2) {
                this.log("  " + classes[i2].getQualifiedName());
            }
            this.mAnnogen.doCodegen();
            this.log("...done.");
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    private File[] path2files(Path path) {
        String[] list = path.list();
        File[] out = new File[list.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new File(list[i]).getAbsoluteFile();
        }
        return out;
    }
}

