/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal.java15;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.internal.elements.ElementContext;
import org.apache.xmlbeans.impl.jam.internal.reflect.Reflect15Delegate;
import org.apache.xmlbeans.impl.jam.internal.reflect.ReflectClassBuilder;
import org.apache.xmlbeans.impl.jam.mutable.MAnnotatedElement;
import org.apache.xmlbeans.impl.jam.mutable.MAnnotation;
import org.apache.xmlbeans.impl.jam.mutable.MClass;
import org.apache.xmlbeans.impl.jam.mutable.MConstructor;
import org.apache.xmlbeans.impl.jam.mutable.MField;
import org.apache.xmlbeans.impl.jam.mutable.MMember;
import org.apache.xmlbeans.impl.jam.mutable.MParameter;
import org.apache.xmlbeans.impl.jam.provider.JamLogger;

public class Reflect15DelegateImpl
implements Reflect15Delegate {
    private ElementContext mContext = null;
    private JamLogger mLogger = null;

    public void init(ElementContext ctx) {
        if (this.mContext != null) {
            throw new IllegalStateException("init called twice");
        }
        this.mContext = ctx;
        this.mLogger = this.mContext.getLogger();
    }

    public void populateAnnotationTypeIfNecessary(Class cd, MClass clazz, ReflectClassBuilder builder) {
        clazz.setIsAnnotationType(cd.isAnnotation());
    }

    public Class getAnnotationClassFor(Object annotation) {
        return ((Annotation)annotation).annotationType();
    }

    public void init(JamLogger logger) {
        this.mLogger = logger;
    }

    public Object[] getAnnotations(Package on) {
        return on.getAnnotations();
    }

    public Object[] getAnnotations(Class on) {
        return on.getAnnotations();
    }

    public Object[] getAnnotations(Method on) {
        return on.getAnnotations();
    }

    public Object[] getAnnotations(Field on) {
        return on.getAnnotations();
    }

    public Object[] getAnnotations(Constructor on) {
        return on.getAnnotations();
    }

    public Object[] getAnnotations(Method on, int pnum) {
        return on.getParameterAnnotations()[pnum];
    }

    public Object[] getAnnotations(Constructor on, int pnum) {
        return on.getParameterAnnotations()[pnum];
    }

    public void extractAnnotations(MMember dest, Method src) {
        Annotation[] anns = src.getDeclaredAnnotations();
        if (anns == null) {
            return;
        }
        this.extractAnnotations((MAnnotatedElement)dest, anns);
    }

    public void extractAnnotations(MConstructor dest, Constructor src) {
        Annotation[] anns = src.getDeclaredAnnotations();
        if (anns == null) {
            return;
        }
        this.extractAnnotations((MAnnotatedElement)dest, anns);
    }

    public void extractAnnotations(MField dest, Field src) {
        Annotation[] anns = src.getDeclaredAnnotations();
        if (anns == null) {
            return;
        }
        this.extractAnnotations((MAnnotatedElement)dest, anns);
    }

    public void extractAnnotations(MClass dest, Class src) {
        Annotation[] anns = src.getDeclaredAnnotations();
        if (anns == null) {
            return;
        }
        this.extractAnnotations((MAnnotatedElement)dest, anns);
    }

    public void extractAnnotations(MParameter dest, Method src, int paramNum) {
        Annotation[][] anns;
        try {
            anns = src.getParameterAnnotations();
        }
        catch (NullPointerException wtf) {
            if (this.mLogger.isVerbose(this)) {
                this.mLogger.verbose("ignoring unexpected error while calling Method.getParameterAnnotations():");
                this.mLogger.verbose(wtf);
            }
            return;
        }
        if (anns == null) {
            return;
        }
        if (paramNum >= anns.length) {
            if (this.mLogger.isVerbose(this)) {
                this.mLogger.warning("method " + src.getName() + " has fewer than expected parameter annotations ");
            }
            return;
        }
        this.extractAnnotations((MAnnotatedElement)dest, anns[paramNum]);
    }

    public void extractAnnotations(MParameter dest, Constructor src, int paramNum) {
        Annotation[][] anns;
        try {
            anns = src.getParameterAnnotations();
        }
        catch (NullPointerException wtf) {
            if (this.mLogger.isVerbose(this)) {
                this.mLogger.verbose("ignoring unexpected error while calling Constructor.getParameterAnnotations():");
                this.mLogger.verbose(wtf);
            }
            return;
        }
        if (anns == null) {
            return;
        }
        if (paramNum >= anns.length) {
            if (this.mLogger.isVerbose(this)) {
                this.mLogger.warning("constructor " + src.getName() + " has fewer than expected parameter annotations ");
            }
            return;
        }
        this.extractAnnotations((MAnnotatedElement)dest, anns[paramNum]);
    }

    public boolean isEnum(Class clazz) {
        return clazz.isEnum();
    }

    public Constructor getEnclosingConstructor(Class clazz) {
        return clazz.getEnclosingConstructor();
    }

    public Method getEnclosingMethod(Class clazz) {
        return clazz.getEnclosingMethod();
    }

    private void extractAnnotations(MAnnotatedElement dest, Annotation[] anns) {
        if (anns == null || anns.length == 0) {
            return;
        }
        for (int i = 0; i < anns.length; ++i) {
            MAnnotation destAnn = dest.findOrCreateAnnotation(anns[i].annotationType().getName());
            destAnn.setAnnotationInstance(anns[i]);
            this.populateAnnotation(destAnn, anns[i]);
        }
    }

    private void populateAnnotation(MAnnotation dest, Annotation src) {
        boolean isVerbose = this.mLogger.isVerbose(this);
        if (src == null) {
            throw new IllegalArgumentException();
        }
        Class<? extends Annotation> annType = src.annotationType();
        if (isVerbose) {
            this.mLogger.verbose("type is " + annType.getName());
        }
        Method[] methods = annType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> c;
            int mods;
            if (isVerbose) {
                this.mLogger.verbose("examining " + methods[i].toString());
            }
            if (Modifier.isStatic(mods = methods[i].getModifiers()) || !Modifier.isPublic(mods) || methods[i].getParameterTypes().length > 0 || Object.class.equals(c = methods[i].getDeclaringClass()) || Annotation.class.equals(c)) continue;
            try {
                if (isVerbose) {
                    this.mLogger.verbose("invoking " + methods[i].getName() + "()");
                }
                Object value = methods[i].invoke((Object)src, (Object[])null);
                if (isVerbose) {
                    this.mLogger.verbose("value is " + value);
                }
                if (value instanceof Annotation) {
                    if (isVerbose) {
                        this.mLogger.verbose("it's nested!!  creating for " + methods[i].getName() + " and " + annType.getName());
                    }
                    MAnnotation nested = dest.createNestedValue(methods[i].getName(), annType.getName());
                    nested.setAnnotationInstance(value);
                    this.populateAnnotation(nested, (Annotation)value);
                    continue;
                }
                if (value instanceof Annotation[]) {
                    Annotation[] anns = (Annotation[])value;
                    MAnnotation[] nested = dest.createNestedValueArray(methods[i].getName(), methods[i].getReturnType().getComponentType().getName(), anns.length);
                    for (int j = 0; j < anns.length; ++j) {
                        this.populateAnnotation(nested[j], anns[j]);
                    }
                    continue;
                }
                JClass type = this.mContext.getClassLoader().loadClass(methods[i].getReturnType().getName());
                dest.setSimpleValue(methods[i].getName(), value, type);
                continue;
            }
            catch (IllegalAccessException e) {
                this.mLogger.warning(e);
                continue;
            }
            catch (InvocationTargetException e) {
                this.mLogger.warning(e);
            }
        }
    }
}

