/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.xmlbeans.impl.jam.internal.elements.ElementContext;
import org.apache.xmlbeans.impl.jam.internal.reflect.Reflect15Delegate;
import org.apache.xmlbeans.impl.jam.mutable.MClass;
import org.apache.xmlbeans.impl.jam.mutable.MConstructor;
import org.apache.xmlbeans.impl.jam.mutable.MField;
import org.apache.xmlbeans.impl.jam.mutable.MInvokable;
import org.apache.xmlbeans.impl.jam.mutable.MMethod;
import org.apache.xmlbeans.impl.jam.mutable.MParameter;
import org.apache.xmlbeans.impl.jam.provider.JamClassBuilder;
import org.apache.xmlbeans.impl.jam.provider.JamClassPopulator;

public class ReflectClassBuilder
extends JamClassBuilder
implements JamClassPopulator {
    private static final String JAVA15_DELEGATE = "org.apache.xmlbeans.impl.jam.internal.java15.Reflect15DelegateImpl";
    private ClassLoader mLoader;
    private Reflect15Delegate mDelegate = null;

    public ReflectClassBuilder(ClassLoader rcl) {
        if (rcl == null) {
            throw new IllegalArgumentException("null rcl");
        }
        this.mLoader = rcl;
    }

    public void init(ElementContext ctx) {
        super.init(ctx);
        this.initDelegate(ctx);
    }

    public MClass build(String packageName, String className) {
        Class<?> rclass;
        this.assertInitialized();
        if (this.getLogger().isVerbose(this)) {
            this.getLogger().verbose("trying to build '" + packageName + "' '" + className + "'");
        }
        try {
            String loadme = packageName.trim().length() > 0 ? packageName + '.' + className : className;
            rclass = this.mLoader.loadClass(loadme);
        }
        catch (ClassNotFoundException cnfe) {
            this.getLogger().verbose(cnfe, (Object)this);
            return null;
        }
        MClass out = this.createClassToBuild(packageName, className, null, this);
        out.setArtifact(rclass);
        return out;
    }

    public void populate(MClass dest) {
        Class<?>[] inners;
        Class s;
        this.assertInitialized();
        Class src = (Class)dest.getArtifact();
        dest.setModifiers(src.getModifiers());
        dest.setIsInterface(src.isInterface());
        if (this.mDelegate != null) {
            dest.setIsEnumType(this.mDelegate.isEnum(src));
        }
        if ((s = src.getSuperclass()) != null) {
            dest.setSuperclass(s.getName());
        }
        Class<?>[] ints = src.getInterfaces();
        for (int i = 0; i < ints.length; ++i) {
            dest.addInterface(ints[i].getName());
        }
        Field[] fields = null;
        try {
            fields = src.getFields();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                this.populate(dest.addNewField(), fields[i]);
            }
        }
        Method[] methods = src.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.populate(dest.addNewMethod(), methods[i]);
        }
        if (this.mDelegate != null) {
            this.mDelegate.populateAnnotationTypeIfNecessary(src, dest, this);
        }
        Constructor<?>[] ctors = src.getDeclaredConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            this.populate(dest.addNewConstructor(), ctors[i]);
        }
        if (this.mDelegate != null) {
            this.mDelegate.extractAnnotations(dest, src);
        }
        if ((inners = src.getDeclaredClasses()) != null) {
            for (int i = 0; i < inners.length; ++i) {
                if (this.mDelegate != null && (this.mDelegate.getEnclosingConstructor(inners[i]) != null || this.mDelegate.getEnclosingMethod(inners[i]) != null)) continue;
                String simpleName = inners[i].getName();
                int lastDollar = simpleName.lastIndexOf(36);
                char first = (simpleName = simpleName.substring(lastDollar + 1)).charAt(0);
                if ('0' <= first && first <= '9') continue;
                MClass inner = dest.addNewInnerClass(simpleName);
                inner.setArtifact(inners[i]);
                this.populate(inner);
            }
        }
    }

    private void initDelegate(ElementContext ctx) {
        try {
            Class.forName("java.lang.annotation.Annotation");
        }
        catch (ClassNotFoundException e) {
            this.issue14RuntimeWarning(e);
            return;
        }
        try {
            this.mDelegate = (Reflect15Delegate)Class.forName(JAVA15_DELEGATE).newInstance();
            this.mDelegate.init(ctx);
        }
        catch (ClassNotFoundException e) {
            this.issue14BuildWarning(e);
        }
        catch (IllegalAccessException e) {
            this.issue14BuildWarning(e);
        }
        catch (InstantiationException e) {
            this.issue14BuildWarning(e);
        }
    }

    private void populate(MField dest, Field src) {
        dest.setSimpleName(src.getName());
        dest.setType(src.getType().getName());
        dest.setModifiers(src.getModifiers());
        if (this.mDelegate != null) {
            this.mDelegate.extractAnnotations(dest, src);
        }
    }

    private void populate(MConstructor dest, Constructor src) {
        dest.setSimpleName(src.getName());
        dest.setModifiers(src.getModifiers());
        Class[] exceptions = src.getExceptionTypes();
        this.addThrows(dest, exceptions);
        Class<?>[] paramTypes = src.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            MParameter p = this.addParameter(dest, i, paramTypes[i]);
            if (this.mDelegate == null) continue;
            this.mDelegate.extractAnnotations(p, src, i);
        }
        if (this.mDelegate != null) {
            this.mDelegate.extractAnnotations(dest, src);
        }
    }

    private void populate(MMethod dest, Method src) {
        dest.setSimpleName(src.getName());
        dest.setModifiers(src.getModifiers());
        dest.setReturnType(src.getReturnType().getName());
        Class[] exceptions = src.getExceptionTypes();
        this.addThrows(dest, exceptions);
        Class<?>[] paramTypes = src.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            MParameter p = this.addParameter(dest, i, paramTypes[i]);
            if (this.mDelegate == null) continue;
            this.mDelegate.extractAnnotations(p, src, i);
        }
        if (this.mDelegate != null) {
            this.mDelegate.extractAnnotations(dest, src);
        }
    }

    private void addThrows(MInvokable dest, Class[] exceptionTypes) {
        for (int i = 0; i < exceptionTypes.length; ++i) {
            dest.addException(exceptionTypes[i].getName());
        }
    }

    private MParameter addParameter(MInvokable dest, int paramNum, Class paramType) {
        MParameter p = dest.addNewParameter();
        p.setSimpleName("param" + paramNum);
        p.setType(paramType.getName());
        return p;
    }
}

