/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.newstore2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.impl.common.XPath;
import org.apache.xmlbeans.impl.newstore2.Cur;
import org.apache.xmlbeans.impl.newstore2.Locale;

public abstract class Path {
    public static String _useXqrlForXpath;
    public static String _useXbeanForXpath;
    private static final int FORCE_XQRL = 0;
    private static final int FORCE_XBEAN = 1;
    private static final int FORCE_NEITHER = 2;
    protected final String _pathKey;
    private static HashMap _xbeanPathCache;
    private static HashMap _xqrlPathCache;
    private static Method _xqrlCompilePath;
    static final /* synthetic */ boolean $assertionsDisabled;

    Path(String key) {
        this._pathKey = key;
    }

    abstract PathEngine execute(Cur var1);

    static String getCurrentNodeVar(XmlOptions options) {
        String currentNodeVar = "this";
        if ((options = XmlOptions.maskNull(options)).hasOption("XQUERY_CURRENT_NODE_VAR") && (currentNodeVar = (String)options.get("XQUERY_CURRENT_NODE_VAR")).startsWith("$")) {
            throw new IllegalArgumentException("Omit the '$' prefix for the current node variable");
        }
        return currentNodeVar;
    }

    public static Path getCompiledPath(String pathExpr, XmlOptions options) {
        int force = (options = XmlOptions.maskNull(options)).hasOption(_useXqrlForXpath) ? 0 : (options.hasOption(_useXbeanForXpath) ? 1 : 2);
        return Path.getCompiledPath(pathExpr, force, Path.getCurrentNodeVar(options));
    }

    static synchronized Path getCompiledPath(String pathExpr, int force, String currentVar) {
        if (force == 0) {
            Path path = (Path)_xqrlPathCache.get(pathExpr);
            if (path == null) {
                path = Path.createXqrlCompiledPath(pathExpr, currentVar);
                if (path == null) {
                    throw new RuntimeException("Can't force XQRL: Can't find xqrl");
                }
                _xqrlPathCache.put(path._pathKey, path);
            }
            return path;
        }
        if (force == 1) {
            Path path = (Path)_xbeanPathCache.get(pathExpr);
            if (path == null) {
                path = XbeanPath.create(pathExpr, currentVar);
                if (path == null) {
                    throw new XmlRuntimeException("Path too complex for XBean path engine");
                }
                _xbeanPathCache.put(path._pathKey, path);
            }
            return path;
        }
        if (!$assertionsDisabled && force != 2) {
            throw new AssertionError();
        }
        Path path = (Path)_xbeanPathCache.get(pathExpr);
        if (path == null) {
            path = (Path)_xqrlPathCache.get(pathExpr);
        }
        if (path == null) {
            path = XbeanPath.create(pathExpr, currentVar);
            if (path != null) {
                _xbeanPathCache.put(path._pathKey, path);
            } else {
                path = Path.createXqrlCompiledPath(pathExpr, currentVar);
                if (path == null) {
                    throw new RuntimeException("Path too complex for xmlbeans");
                }
                _xqrlPathCache.put(path._pathKey, path);
            }
        }
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError();
        }
        return path;
    }

    public static synchronized String compilePath(String pathExpr, XmlOptions options) {
        return Path.getCompiledPath((String)pathExpr, (XmlOptions)options)._pathKey;
    }

    private static Path createXqrlCompiledPath(String pathExpr, String currentVar) {
        if (_xqrlCompilePath == null) {
            try {
                Class<?> xqrlImpl = Class.forName("org.apache.xmlbeans.impl.newstore2.XqrlImpl");
                _xqrlCompilePath = xqrlImpl.getDeclaredMethod("compilePath", String.class, String.class, Boolean.class);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Object[] args = new Object[]{pathExpr, currentVar, new Boolean(true)};
        try {
            return (Path)_xqrlCompilePath.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        $assertionsDisabled = !Path.class.desiredAssertionStatus();
        _useXqrlForXpath = "use xqrl for xpath";
        _useXbeanForXpath = "use xbean for xpath";
        _xbeanPathCache = new HashMap();
        _xqrlPathCache = new HashMap();
    }

    private static final class XbeanPathEngine
    extends XPath.ExecutionContext
    implements PathEngine {
        private final long _version;
        private Cur _cur;
        static final /* synthetic */ boolean $assertionsDisabled;

        XbeanPathEngine(XPath xpath, Cur c) {
            if (!$assertionsDisabled && !c.isContainer()) {
                throw new AssertionError();
            }
            this._version = c._locale.version();
            this._cur = c.weakCur(this);
            this._cur.push();
            this.init(xpath);
            int ret = this.start();
            if ((ret & 1) != 0) {
                c.addToSelection();
            }
            this.doAttrs(ret, c);
            if ((ret & 2) == 0 || !Locale.toFirstChildElement(this._cur)) {
                this.release();
            }
        }

        private void advance(Cur c) {
            if (!$assertionsDisabled && this._cur == null) {
                throw new AssertionError();
            }
            if (this._cur.isFinish()) {
                if (this._cur.isAtEndOfLastPush()) {
                    this.release();
                } else {
                    this.end();
                    this._cur.next();
                }
            } else if (this._cur.isElem()) {
                int ret = this.element(this._cur.getName());
                if ((ret & 1) != 0) {
                    c.addToSelection(this._cur);
                }
                this.doAttrs(ret, c);
                if ((ret & 2) == 0 || !Locale.toFirstChildElement(this._cur)) {
                    this.end();
                    this._cur.skip();
                }
            } else {
                this._cur.next();
            }
        }

        private void doAttrs(int ret, Cur c) {
            if (!$assertionsDisabled && !this._cur.isContainer()) {
                throw new AssertionError();
            }
            if ((ret & 4) != 0 && this._cur.toFirstAttr()) {
                do {
                    if (!this.attr(this._cur.getName())) continue;
                    c.addToSelection(this._cur);
                } while (this._cur.toNextAttr());
                this._cur.toParent();
            }
        }

        public boolean next(Cur c) {
            if (this._cur != null && this._version != this._cur._locale.version()) {
                throw new ConcurrentModificationException("Document changed during select");
            }
            int startCount = c.selectionCount();
            while (this._cur != null) {
                this.advance(c);
                if (startCount == c.selectionCount()) continue;
                return true;
            }
            return false;
        }

        public void release() {
            if (this._cur != null) {
                this._cur.release();
                this._cur = null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$newstore2$Path == null ? (class$org$apache$xmlbeans$impl$newstore2$Path = Path.class$("org.apache.xmlbeans.impl.newstore2.Path")) : class$org$apache$xmlbeans$impl$newstore2$Path).desiredAssertionStatus();
        }
    }

    private static final class XbeanPath
    extends Path {
        private final String _currentVar;
        private final XPath _compiledPath;

        static Path create(String pathExpr, String currentVar) {
            try {
                return new XbeanPath(pathExpr, currentVar, XPath.compileXPath(pathExpr, currentVar));
            }
            catch (XPath.XPathCompileException e) {
                return null;
            }
        }

        private XbeanPath(String pathExpr, String currentVar, XPath xpath) {
            super(pathExpr);
            this._currentVar = currentVar;
            this._compiledPath = xpath;
        }

        PathEngine execute(Cur c) {
            if (!c.isContainer() || this._compiledPath.sawDeepDot()) {
                return XbeanPath.getCompiledPath(this._pathKey, 0, this._currentVar).execute(c);
            }
            return new XbeanPathEngine(this._compiledPath, c);
        }
    }

    static interface PathEngine {
        public void release();

        public boolean next(Cur var1);
    }
}

