/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaAttributeGroup;
import org.apache.xmlbeans.SchemaGlobalAttribute;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaIdentityConstraint;
import org.apache.xmlbeans.SchemaModelGroup;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.XBeanDebug;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.ResourceLoader;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderBase;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl;

public class SchemaTypeLoaderImpl
extends SchemaTypeLoaderBase {
    private ResourceLoader _resourceLoader;
    private ClassLoader _classLoader;
    private SchemaTypeLoader[] _searchPath;
    private Map _classpathTypeSystems;
    private Map _classLoaderTypeSystems;
    private Map _elementCache;
    private Map _attributeCache;
    private Map _modelGroupCache;
    private Map _attributeGroupCache;
    private Map _idConstraintCache;
    private Map _typeCache;
    private Map _documentCache;
    private Map _classnameCache;
    public static String LOAD_METADATA_PACKAGE;
    private static ThreadLocal _cachedTypeSystems;
    private static final SchemaTypeLoader[] EMPTY_SCHEMATYPELOADER_ARRAY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static SchemaTypeLoaderImpl getContextTypeLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList a = (ArrayList)_cachedTypeSystems.get();
        int candidate = -1;
        SchemaTypeLoaderImpl result = null;
        for (int i = 0; i < a.size(); ++i) {
            SchemaTypeLoaderImpl tl = (SchemaTypeLoaderImpl)((SoftReference)a.get(i)).get();
            if (tl == null) {
                if (!$assertionsDisabled && i <= candidate) {
                    throw new AssertionError();
                }
                a.remove(i--);
                continue;
            }
            if (tl._classLoader != cl) continue;
            if (!($assertionsDisabled || candidate == -1 && result == null)) {
                throw new AssertionError();
            }
            candidate = i;
            result = tl;
            break;
        }
        if (candidate < 0) {
            result = new SchemaTypeLoaderImpl(new SchemaTypeLoader[]{BuiltinSchemaTypeSystem.get()}, null, cl);
            candidate = a.size();
            a.add(new SoftReference<SchemaTypeLoaderImpl>(result));
        }
        if (candidate > 0) {
            Object t = a.get(0);
            a.set(0, a.get(candidate));
            a.set(candidate, t);
        }
        return result;
    }

    public static SchemaTypeLoader build(SchemaTypeLoader[] searchPath, ResourceLoader resourceLoader, ClassLoader classLoader) {
        if (searchPath == null) {
            searchPath = EMPTY_SCHEMATYPELOADER_ARRAY;
        } else {
            SubLoaderList list = new SubLoaderList();
            for (int i = 0; i < searchPath.length; ++i) {
                if (searchPath[i] == null) {
                    throw new IllegalArgumentException("searchPath[" + i + "] is null");
                }
                if (!(searchPath[i] instanceof SchemaTypeLoaderImpl)) {
                    list.add(searchPath[i]);
                    continue;
                }
                SchemaTypeLoaderImpl sub = (SchemaTypeLoaderImpl)searchPath[i];
                if (sub._classLoader != null || sub._resourceLoader != null) {
                    list.add(sub);
                    continue;
                }
                for (int j = 0; j < sub._searchPath.length; ++j) {
                    list.add(sub._searchPath[j]);
                }
            }
            searchPath = list.toArray();
        }
        if (searchPath.length == 1 && resourceLoader == null && classLoader == null) {
            return searchPath[0];
        }
        return new SchemaTypeLoaderImpl(searchPath, resourceLoader, classLoader);
    }

    private SchemaTypeLoaderImpl(SchemaTypeLoader[] searchPath, ResourceLoader resourceLoader, ClassLoader classLoader) {
        this._searchPath = searchPath == null ? EMPTY_SCHEMATYPELOADER_ARRAY : searchPath;
        this._resourceLoader = resourceLoader;
        this._classLoader = classLoader;
        this.initCaches();
    }

    private final void initCaches() {
        this._classpathTypeSystems = Collections.synchronizedMap(new HashMap());
        this._classLoaderTypeSystems = Collections.synchronizedMap(new HashMap());
        this._elementCache = Collections.synchronizedMap(new HashMap());
        this._attributeCache = Collections.synchronizedMap(new HashMap());
        this._modelGroupCache = Collections.synchronizedMap(new HashMap());
        this._attributeGroupCache = Collections.synchronizedMap(new HashMap());
        this._idConstraintCache = Collections.synchronizedMap(new HashMap());
        this._typeCache = Collections.synchronizedMap(new HashMap());
        this._documentCache = Collections.synchronizedMap(new HashMap());
        this._classnameCache = Collections.synchronizedMap(new HashMap());
    }

    SchemaTypeSystemImpl typeSystemForComponent(String searchdir, QName name) {
        String searchfor = searchdir + QNameHelper.hexsafedir(name) + ".xsb";
        String tsname = null;
        if (this._resourceLoader != null) {
            tsname = SchemaTypeLoaderImpl.crackEntry(this._resourceLoader, searchfor);
        }
        if (this._classLoader != null) {
            tsname = SchemaTypeLoaderImpl.crackEntry(this._classLoader, searchfor);
        }
        if (tsname != null) {
            return (SchemaTypeSystemImpl)this.typeSystemForName(tsname);
        }
        return null;
    }

    public SchemaTypeSystem typeSystemForName(String name) {
        SchemaTypeSystemImpl result;
        if (this._resourceLoader != null && (result = this.getTypeSystemOnClasspath(name)) != null) {
            return result;
        }
        if (this._classLoader != null && (result = this.getTypeSystemOnClassloader(name)) != null) {
            return result;
        }
        return null;
    }

    SchemaTypeSystemImpl typeSystemForClassname(String searchdir, String name) {
        String tsname;
        String searchfor = searchdir + name.replace('.', '/') + ".xsb";
        if (this._resourceLoader != null && (tsname = SchemaTypeLoaderImpl.crackEntry(this._resourceLoader, searchfor)) != null) {
            return this.getTypeSystemOnClasspath(tsname);
        }
        if (this._classLoader != null && (tsname = SchemaTypeLoaderImpl.crackEntry(this._classLoader, searchfor)) != null) {
            return this.getTypeSystemOnClassloader(tsname);
        }
        return null;
    }

    SchemaTypeSystemImpl getTypeSystemOnClasspath(String name) {
        SchemaTypeSystemImpl result = (SchemaTypeSystemImpl)this._classpathTypeSystems.get(name);
        if (result == null) {
            result = new SchemaTypeSystemImpl(this._resourceLoader, name, this);
            this._classpathTypeSystems.put(name, result);
        }
        return result;
    }

    SchemaTypeSystemImpl getTypeSystemOnClassloader(String name) {
        XBeanDebug.trace(1, "Finding type system " + name + " on classloader", 0);
        SchemaTypeSystemImpl result = (SchemaTypeSystemImpl)this._classLoaderTypeSystems.get(name);
        if (result == null) {
            XBeanDebug.trace(1, "Type system " + name + " not cached - consulting field", 0);
            result = SchemaTypeSystemImpl.forName(name, this._classLoader);
            this._classLoaderTypeSystems.put(name, result);
        }
        return result;
    }

    static String crackEntry(ResourceLoader loader, String searchfor) {
        InputStream is = loader.getResourceAsStream(searchfor);
        if (is == null) {
            return null;
        }
        return SchemaTypeLoaderImpl.crackPointer(is);
    }

    static String crackEntry(ClassLoader loader, String searchfor) {
        InputStream stream = loader.getResourceAsStream(searchfor);
        if (stream == null) {
            return null;
        }
        return SchemaTypeLoaderImpl.crackPointer(stream);
    }

    static String crackPointer(InputStream stream) {
        return SchemaTypeSystemImpl.crackPointer(stream);
    }

    public boolean isNamespaceDefined(String namespace) {
        for (int i = 0; i < this._searchPath.length; ++i) {
            if (!this._searchPath[i].isNamespaceDefined(namespace)) continue;
            return true;
        }
        SchemaTypeSystemImpl sts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/namespace/", new QName(namespace, "xmlns"));
        return sts != null;
    }

    public SchemaType.Ref findTypeRef(QName name) {
        SchemaType.Ref result = (SchemaType.Ref)this._typeCache.get(name);
        if (result == null && !this._typeCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findTypeRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/type/", name)) != null) {
                result = ts.findTypeRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered type " + QNameHelper.pretty(name) + " but does not return it"));
                }
            }
            this._typeCache.put(name, result);
        }
        return result;
    }

    public SchemaType typeForClassname(String classname) {
        SchemaType result = (SchemaType)this._classnameCache.get(classname = classname.replace('$', '.'));
        if (result == null && !this._classnameCache.containsKey(classname)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].typeForClassname(classname)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForClassname("schema" + LOAD_METADATA_PACKAGE + "/javaname/", classname)) != null) {
                result = ts.typeForClassname(classname);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered type " + classname + " but does not return it"));
                }
            }
            this._classnameCache.put(classname, result);
        }
        return result;
    }

    public SchemaType.Ref findDocumentTypeRef(QName name) {
        SchemaType.Ref result = (SchemaType.Ref)this._documentCache.get(name);
        if (result == null && !this._documentCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findDocumentTypeRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/element/", name)) != null) {
                result = ts.findDocumentTypeRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered element " + QNameHelper.pretty(name) + " but does not contain document type"));
                }
            }
            this._documentCache.put(name, result);
        }
        return result;
    }

    public SchemaType.Ref findAttributeTypeRef(QName name) {
        SchemaType.Ref result = (SchemaType.Ref)this._attributeCache.get(name);
        if (result == null && !this._attributeCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findAttributeTypeRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/attribute/", name)) != null) {
                result = ts.findAttributeTypeRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered attribute " + QNameHelper.pretty(name) + " but does not contain attribute type"));
                }
            }
            this._attributeCache.put(name, result);
        }
        return result;
    }

    public SchemaGlobalElement.Ref findElementRef(QName name) {
        SchemaGlobalElement.Ref result = (SchemaGlobalElement.Ref)this._elementCache.get(name);
        if (result == null && !this._elementCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findElementRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/element/", name)) != null) {
                result = ts.findElementRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered element " + QNameHelper.pretty(name) + " but does not return it"));
                }
            }
            this._elementCache.put(name, result);
        }
        return result;
    }

    public SchemaGlobalAttribute.Ref findAttributeRef(QName name) {
        SchemaGlobalAttribute.Ref result = (SchemaGlobalAttribute.Ref)this._attributeCache.get(name);
        if (result == null && !this._attributeCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findAttributeRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/attribute/", name)) != null) {
                result = ts.findAttributeRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered attribute " + QNameHelper.pretty(name) + " but does not return it"));
                }
            }
            this._attributeCache.put(name, result);
        }
        return result;
    }

    public SchemaModelGroup.Ref findModelGroupRef(QName name) {
        SchemaModelGroup.Ref result = (SchemaModelGroup.Ref)this._modelGroupCache.get(name);
        if (result == null && !this._modelGroupCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findModelGroupRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/modelgroup/", name)) != null) {
                result = ts.findModelGroupRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered model group " + QNameHelper.pretty(name) + " but does not return it"));
                }
            }
            this._modelGroupCache.put(name, result);
        }
        return result;
    }

    public SchemaAttributeGroup.Ref findAttributeGroupRef(QName name) {
        SchemaAttributeGroup.Ref result = (SchemaAttributeGroup.Ref)this._attributeGroupCache.get(name);
        if (result == null && !this._attributeGroupCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findAttributeGroupRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/attributegroup/", name)) != null) {
                result = ts.findAttributeGroupRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered attribute group " + QNameHelper.pretty(name) + " but does not return it"));
                }
            }
            this._attributeGroupCache.put(name, result);
        }
        return result;
    }

    public SchemaIdentityConstraint.Ref findIdentityConstraintRef(QName name) {
        SchemaIdentityConstraint.Ref result = (SchemaIdentityConstraint.Ref)this._idConstraintCache.get(name);
        if (result == null && !this._idConstraintCache.containsKey(name)) {
            SchemaTypeSystemImpl ts;
            for (int i = 0; i < this._searchPath.length && null == (result = this._searchPath[i].findIdentityConstraintRef(name)); ++i) {
            }
            if (result == null && (ts = this.typeSystemForComponent("schema" + LOAD_METADATA_PACKAGE + "/identityconstraint/", name)) != null) {
                result = ts.findIdentityConstraintRef(name);
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)("Type system registered identity constraint " + QNameHelper.pretty(name) + " but does not return it"));
                }
            }
            this._idConstraintCache.put(name, result);
        }
        return result;
    }

    public InputStream getSourceAsStream(String sourceName) {
        InputStream result = null;
        if (!sourceName.startsWith("/")) {
            sourceName = "/" + sourceName;
        }
        if (this._resourceLoader != null) {
            result = this._resourceLoader.getResourceAsStream("schema" + LOAD_METADATA_PACKAGE + "/src" + sourceName);
        }
        if (result == null && this._classLoader != null) {
            return this._classLoader.getResourceAsStream("schema" + LOAD_METADATA_PACKAGE + "/src" + sourceName);
        }
        return result;
    }

    static {
        $assertionsDisabled = !SchemaTypeLoaderImpl.class.desiredAssertionStatus();
        LOAD_METADATA_PACKAGE = SchemaTypeSystemImpl.METADATA_PACKAGE;
        _cachedTypeSystems = new ThreadLocal(){

            protected Object initialValue() {
                return new ArrayList();
            }
        };
        EMPTY_SCHEMATYPELOADER_ARRAY = new SchemaTypeLoader[0];
    }

    private static class SubLoaderList {
        private List theList = new ArrayList();
        private Map seen = new IdentityHashMap();

        private SubLoaderList() {
        }

        private boolean add(SchemaTypeLoader loader) {
            if (this.seen.containsKey(loader)) {
                return false;
            }
            this.theList.add(loader);
            this.seen.put(loader, null);
            return true;
        }

        private SchemaTypeLoader[] toArray() {
            return this.theList.toArray(EMPTY_SCHEMATYPELOADER_ARRAY);
        }
    }
}

