/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;

public class InstanceValidator {
    public static void printUsage() {
        System.out.println("Validates a schema defintion and instances within the schema.");
        System.out.println("Usage: validate [switches] schema.xsd instance.xml");
        System.out.println("Switches:");
        System.out.println("    -dl    enable network downloads for imports and includes");
        System.out.println("    -nopvr disable particle valid (restriction) rule");
        System.out.println("    -noupa diable unique particle attributeion rule");
        System.out.println("    -license prints license information");
    }

    public static void main(String[] args) {
        SchemaTypeLoader sLoader;
        HashSet<String> flags = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        flags.add("dl");
        flags.add("noupa");
        flags.add("nopvr");
        CommandLine cl = new CommandLine(args, flags, Collections.EMPTY_SET);
        if (cl.getOpt("h") != null || cl.getOpt("help") != null || cl.getOpt("usage") != null) {
            InstanceValidator.printUsage();
            System.exit(0);
            return;
        }
        String[] badopts = cl.getBadOpts();
        if (badopts.length > 0) {
            for (int i = 0; i < badopts.length; ++i) {
                System.out.println("Unrecognized option: " + badopts[i]);
            }
            InstanceValidator.printUsage();
            System.exit(0);
            return;
        }
        if (cl.getOpt("license") != null) {
            CommandLine.printLicense();
            System.exit(0);
            return;
        }
        if (cl.getOpt("version") != null) {
            CommandLine.printVersion();
            System.exit(0);
            return;
        }
        if (cl.args().length == 0) {
            return;
        }
        boolean dl = cl.getOpt("dl") != null;
        boolean nopvr = cl.getOpt("nopvr") != null;
        boolean noupa = cl.getOpt("noupa") != null;
        File[] schemaFiles = cl.filesEndingWith(".xsd");
        File[] instanceFiles = cl.filesEndingWith(".xml");
        ArrayList<XmlObject> sdocs = new ArrayList<XmlObject>();
        for (int i = 0; i < schemaFiles.length; ++i) {
            try {
                sdocs.add(XmlObject.Factory.parse(schemaFiles[i], new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                continue;
            }
            catch (Exception e) {
                System.err.println(schemaFiles[i] + " not loadable: " + e);
            }
        }
        XmlObject[] schemas = sdocs.toArray(new XmlObject[0]);
        ArrayList compErrors = new ArrayList();
        XmlOptions schemaOptions = new XmlOptions();
        schemaOptions.setErrorListener(compErrors);
        if (dl) {
            schemaOptions.setCompileDownloadUrls();
        }
        if (nopvr) {
            schemaOptions.setCompileNoPvrRule();
        }
        if (noupa) {
            schemaOptions.setCompileNoUpaRule();
        }
        try {
            sLoader = XmlBeans.loadXsd(schemas, schemaOptions);
        }
        catch (Exception e) {
            if (compErrors.isEmpty() || !(e instanceof XmlException)) {
                e.printStackTrace(System.err);
            }
            System.out.println("Schema invalid");
            Iterator i = compErrors.iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
            return;
        }
        for (int i = 0; i < instanceFiles.length; ++i) {
            XmlObject xobj;
            try {
                xobj = sLoader.parse(instanceFiles[i], null, new XmlOptions().setLoadLineNumbers());
            }
            catch (Exception e) {
                System.err.println(instanceFiles[i] + " not loadable: " + e);
                e.printStackTrace(System.err);
                continue;
            }
            ArrayList errors = new ArrayList();
            if (xobj.schemaType() == XmlObject.type) {
                System.out.println(instanceFiles[i] + " NOT valid.  ");
                System.out.println("  Document type not found.");
                continue;
            }
            if (xobj.validate(new XmlOptions().setErrorListener(errors))) {
                System.out.println(instanceFiles[i] + " valid.");
                continue;
            }
            System.out.println(instanceFiles[i] + " NOT valid.");
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        }
    }
}

