/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.examples;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class CobolSparkExample2$ {
    public static final CobolSparkExample2$ MODULE$;

    static {
        new CobolSparkExample2$();
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        SparkSession.Builder sparkBuilder = SparkSession$.MODULE$.builder().appName("Cobol source reader example 2");
        SparkSession spark = sparkBuilder.master("local[*]").getOrCreate();
        String copybook = new StringOps(Predef$.MODULE$.augmentString("        01  COMPANY-DETAILS.\n        |            05  SEGMENT-ID           PIC X(5).\n        |            05  COMPANY-ID           PIC X(10).\n        |            05  COMPANY.\n        |               10  NAME              PIC X(15).\n        |               10  ADDRESS           PIC X(25).\n        |               10  TAXPAYER.\n        |                  15  TAXPAYER-TYPE  PIC X(1).\n        |                  15  TAXPAYER-STR   PIC X(8).\n        |                  15  TAXPAYER-NUM  REDEFINES TAXPAYER-STR\n        |                                     PIC 9(8) COMP.\n        |            05  CONTACT REDEFINES COMPANY.\n        |               10  PHONE-NUMBER      PIC X(17).\n        |               10  CONTACT-PERSON    PIC X(28).\n        |")).stripMargin();
        Dataset df = spark.read().format("cobol").option("copybook_contents", copybook).option("schema_retention_policy", "collapse_root").option("is_record_sequence", "true").load("examples/example_data/multisegment_data/COMP.DETAILS.SEP30.DATA.dat");
        df.printSchema();
        df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY_ID"}))).$((Seq)Nil$.MODULE$)})).show(10, false);
        Dataset dfCompanies = df.filter(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SEGMENT_ID"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)"C")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY_ID"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY.NAME"}))).$((Seq)Nil$.MODULE$).as("COMPANY_NAME"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY.ADDRESS"}))).$((Seq)Nil$.MODULE$), functions$.MODULE$.when(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY.TAXPAYER.TAXPAYER_TYPE"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)"A"), (Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY.TAXPAYER.TAXPAYER_STR"}))).$((Seq)Nil$.MODULE$)).otherwise((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY.TAXPAYER.TAXPAYER_NUM"}))).$((Seq)Nil$.MODULE$)).cast((DataType)StringType$.MODULE$).as("TAXPAYER")}));
        dfCompanies.printSchema();
        dfCompanies.show(50, false);
        Dataset dfContacts = df.filter(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SEGMENT_ID"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)"P")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY_ID"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONTACT.CONTACT_PERSON"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONTACT.PHONE_NUMBER"}))).$((Seq)Nil$.MODULE$)}));
        dfContacts.printSchema();
        dfContacts.show(50, false);
        Dataset dfJoined = dfCompanies.join(dfContacts, "COMPANY_ID");
        dfJoined.printSchema();
        dfJoined.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMPANY_ID"}))).$((Seq)Nil$.MODULE$)})).show(50, false);
    }

    private CobolSparkExample2$() {
        MODULE$ = this;
    }
}

