/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.reader.index;

import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import za.co.absa.cobrix.cobol.parser.Copybook;
import za.co.absa.cobrix.cobol.parser.ast.Primitive;
import za.co.absa.cobrix.cobol.parser.decoders.BinaryUtils$;
import za.co.absa.cobrix.cobol.parser.stream.SimpleStream;
import za.co.absa.cobrix.spark.cobol.reader.Constants$;
import za.co.absa.cobrix.spark.cobol.reader.index.entry.SparseIndexEntry;

public final class IndexGenerator$ {
    public static final IndexGenerator$ MODULE$;
    private final int rdwHeaderBlock;

    static {
        new IndexGenerator$();
    }

    private int rdwHeaderBlock() {
        return this.rdwHeaderBlock;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer<SparseIndexEntry> sparseIndexGenerator(int fileId, SimpleStream dataStream, boolean isRdwBigEndian, Option<Object> recordsPerIndexEntry, Option<Object> sizePerIndexEntryMB, Option<Copybook> copybook, Option<Primitive> segmentField, String rootSegmentId) {
        long byteIndex = 0L;
        ArrayBuffer index = new ArrayBuffer();
        String rootRecordId = "";
        int rootRecordSize = -1;
        boolean recordsInChunk = false;
        long bytesInChunk = 0L;
        int recordIndex = 0;
        boolean isHierarchical = copybook.nonEmpty() && segmentField.nonEmpty();
        boolean isSplitBySize = recordsPerIndexEntry.isEmpty() && sizePerIndexEntryMB.nonEmpty();
        Function2<Object, Object, Object> needSplit = this.getSplitCondition(recordsPerIndexEntry, sizePerIndexEntryMB);
        SparseIndexEntry indexEntry = new SparseIndexEntry(0L, -1L, fileId, recordIndex);
        index.$plus$eq((Object)indexEntry);
        boolean endOfFileReached = false;
        while (true) {
            void var17_15;
            int recordSize;
            block9: {
                long l;
                boolean bl;
                void var20_18;
                int n;
                String string;
                void var18_16;
                byte[] record;
                block11: {
                    String curSegmentId;
                    block12: {
                        block10: {
                            boolean bl2;
                            block8: {
                                if (endOfFileReached) {
                                    if (isHierarchical && new StringOps(Predef$.MODULE$.augmentString(rootSegmentId)).nonEmpty() && rootRecordId.isEmpty()) {
                                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Root segment ", "=='", "' not found in the data file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Primitive)segmentField.get()).name(), rootSegmentId})));
                                    }
                                    if (isHierarchical && rootRecordId.isEmpty()) {
                                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Root segment ", " ie empty for every record in the data file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Primitive)segmentField.get()).name()})));
                                    }
                                    return index;
                                }
                                recordSize = this.getNextRecordSize(dataStream, isRdwBigEndian);
                                if (recordSize > 0) break block8;
                                bl2 = true;
                                break block9;
                            }
                            record = dataStream.next(recordSize);
                            if (record.length >= recordSize) break block10;
                            bl2 = true;
                            break block9;
                        }
                        if (var18_16 == false || !string.isEmpty()) break block11;
                        curSegmentId = this.getSegmentId((Copybook)copybook.get(), (Primitive)segmentField.get(), record);
                        if (new StringOps(Predef$.MODULE$.augmentString(curSegmentId)).nonEmpty() && rootSegmentId.isEmpty()) break block12;
                        if (!new StringOps(Predef$.MODULE$.augmentString(rootSegmentId)).nonEmpty()) break block11;
                        String string2 = curSegmentId;
                        String string3 = rootSegmentId;
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block11;
                    }
                    n = recordSize;
                    string = curSegmentId;
                }
                if (var20_18.apply$mcZIJ$sp(bl ? 1 : 0, l) && (var18_16 == false || this.isSegmentGoodForSplit(n, string, (Copybook)copybook.get(), (Primitive)segmentField.get(), record))) {
                    void var19_17;
                    void var11_10;
                    void var9_9;
                    SparseIndexEntry indexEntry2 = new SparseIndexEntry((long)var9_9, -1L, fileId, (long)var17_15);
                    int len = var11_10.length();
                    SparseIndexEntry qual$1 = (SparseIndexEntry)var11_10.apply(len - 1);
                    long x$1 = indexEntry2.offsetFrom();
                    long x$2 = qual$1.copy$default$1();
                    int x$3 = qual$1.copy$default$3();
                    long x$4 = qual$1.copy$default$4();
                    var11_10.update(len - 1, (Object)qual$1.copy(x$2, x$1, x$3, x$4));
                    var11_10.$plus$eq((Object)indexEntry2);
                    bl = false;
                    l = var19_17 != false ? (l -= (long)BoxesRunTime.unboxToInt((Object)sizePerIndexEntryMB.get()) * (long)Constants$.MODULE$.megabyte()) : 0L;
                }
            }
            var9_9 += (long)(this.rdwHeaderBlock() + recordSize);
            ++var17_15;
            bl += true;
            l += (long)(this.rdwHeaderBlock() + recordSize);
        }
    }

    public Option<Object> sparseIndexGenerator$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> sparseIndexGenerator$default$5() {
        return None$.MODULE$;
    }

    public Option<Copybook> sparseIndexGenerator$default$6() {
        return None$.MODULE$;
    }

    public Option<Primitive> sparseIndexGenerator$default$7() {
        return None$.MODULE$;
    }

    public String sparseIndexGenerator$default$8() {
        return "";
    }

    private Function2<Object, Object, Object> getSplitCondition(Option<Object> recordsPerIndexEntry, Option<Object> sizePerIndexEntryMB) {
        long bytesPerIndexEntry = (long)BoxesRunTime.unboxToInt((Object)sizePerIndexEntryMB.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Constants$.MODULE$.defaultIndexEntrySizeMB();
            }
        })) * (long)Constants$.MODULE$.megabyte();
        int recPerIndexEntry = BoxesRunTime.unboxToInt((Object)recordsPerIndexEntry.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }));
        return recordsPerIndexEntry.isDefined() ? new Serializable(recPerIndexEntry){
            public static final long serialVersionUID = 0L;
            private final int recPerIndexEntry$1;

            public final boolean apply(int records, long currentSize) {
                return this.apply$mcZIJ$sp(records, currentSize);
            }

            public boolean apply$mcZIJ$sp(int records, long currentSize) {
                return records >= this.recPerIndexEntry$1;
            }
            {
                this.recPerIndexEntry$1 = recPerIndexEntry$1;
            }
        } : new Serializable(bytesPerIndexEntry){
            public static final long serialVersionUID = 0L;
            private final long bytesPerIndexEntry$1;

            public final boolean apply(int records, long currentSize) {
                return this.apply$mcZIJ$sp(records, currentSize);
            }

            public boolean apply$mcZIJ$sp(int records, long currentSize) {
                return currentSize >= this.bytesPerIndexEntry$1;
            }
            {
                this.bytesPerIndexEntry$1 = bytesPerIndexEntry$1;
            }
        };
    }

    private boolean isSegmentGoodForSplit(int rootRecordSize, String rootRecordId, Copybook copybook, Primitive segmentField, byte[] record) {
        boolean bl;
        if (record.length != rootRecordSize) {
            bl = false;
        } else {
            String string = rootRecordId;
            String string2 = this.getSegmentId(copybook, segmentField, record);
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return bl;
    }

    private int getNextRecordSize(SimpleStream dataStream, boolean isRdwBigEndian) {
        return BinaryUtils$.MODULE$.extractRdwRecordSize(dataStream.next(this.rdwHeaderBlock()), isRdwBigEndian, BinaryUtils$.MODULE$.extractRdwRecordSize$default$3());
    }

    private String getSegmentId(Copybook copybook, Primitive segmentIdField, byte[] data) {
        Object v = copybook.extractPrimitiveField(segmentIdField, data, copybook.extractPrimitiveField$default$3());
        return v == null ? "" : v.toString().trim();
    }

    private IndexGenerator$() {
        MODULE$ = this;
        this.rdwHeaderBlock = 4;
    }
}

