/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.replication;

import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.PropertyConfigurator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.generation.HDFSFileWriter;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.identification.IncrementalFileIdProvider;

public final class CobolBinaryFilesReplicator$ {
    public static final CobolBinaryFilesReplicator$ MODULE$;
    private final String PARAM_SOURCE_DIR;
    private final String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_DESTINATION_DIR;
    private final String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_SPACE_BYTES;
    private final String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_PARALLEL_REPLICATORS;
    private final String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_INITIAL_FILE_ID;

    static {
        new CobolBinaryFilesReplicator$();
    }

    private String PARAM_SOURCE_DIR() {
        return this.PARAM_SOURCE_DIR;
    }

    public String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_DESTINATION_DIR() {
        return this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_DESTINATION_DIR;
    }

    public String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_SPACE_BYTES() {
        return this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_SPACE_BYTES;
    }

    public String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_PARALLEL_REPLICATORS() {
        return this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_PARALLEL_REPLICATORS;
    }

    public String za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_INITIAL_FILE_ID() {
        return this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_INITIAL_FILE_ID;
    }

    public void main(String[] args) {
        if (args.length != 5) {
            Predef$.MODULE$.println((Object)this.wrongParametersHelperMessage());
            System.exit(1);
        }
        PropertyConfigurator.configure((String)"log4j.properties");
        Map<String, String> params = this.parseArguments(args);
        String destDir = this.getDestinationDirectory(params);
        long maxAllowedSpaceBytes = this.getMaxAllowedSpaceBytes(params);
        IncrementalFileIdProvider idProvider = new IncrementalFileIdProvider(this.getInitialDestinationFileId(params));
        int maxParallelReplicators = this.getMaxParallelReplicators(params);
        File[] files = new File(this.getFilesSourceDirectory(params)).listFiles();
        Configuration conf = this.getConfiguration();
        int numWorkers = maxParallelReplicators < files.length ? maxParallelReplicators : files.length;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Cobol Binary Files Replicator] Destination directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destDir})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Cobol Binary Files Replicator] Maximum space allowed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)maxAllowedSpaceBytes)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Cobol Binary Files Replicator] Number of workers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numWorkers)})));
        ExecutorService pool = Executors.newFixedThreadPool(numWorkers);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numWorkers).foreach$mVc$sp((Function1)new Serializable(destDir, maxAllowedSpaceBytes, idProvider, files, conf, numWorkers, pool){
            public static final long serialVersionUID = 0L;
            private final String destDir$1;
            private final long maxAllowedSpaceBytes$1;
            private final IncrementalFileIdProvider idProvider$1;
            private final File[] files$1;
            private final Configuration conf$1;
            private final int numWorkers$1;
            private final ExecutorService pool$1;

            public final void apply(int w) {
                this.apply$mcVI$sp(w);
            }

            public void apply$mcVI$sp(int w) {
                this.pool$1.execute(new HDFSFileWriter(this.destDir$1, this.files$1, this.maxAllowedSpaceBytes$1 / (long)this.numWorkers$1, this.conf$1, this.idProvider$1));
            }
            {
                this.destDir$1 = destDir$1;
                this.maxAllowedSpaceBytes$1 = maxAllowedSpaceBytes$1;
                this.idProvider$1 = idProvider$1;
                this.files$1 = files$1;
                this.conf$1 = conf$1;
                this.numWorkers$1 = numWorkers$1;
                this.pool$1 = pool$1;
            }
        });
        pool.shutdown();
    }

    private Map<String, String> parseArguments(String[] args) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])args).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String param) {
                String[] tokens = param.split("=");
                return new Tuple2((Object)tokens[0], (Object)tokens[1]);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
    }

    private String getDestinationDirectory(Map<String, String> params) {
        return (String)params.getOrElse((Object)this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_DESTINATION_DIR(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing parameter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CobolBinaryFilesReplicator$.MODULE$.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_DESTINATION_DIR()})));
            }
        });
    }

    private long getMaxAllowedSpaceBytes(Map<String, String> params) {
        return new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_SPACE_BYTES(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing parameter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CobolBinaryFilesReplicator$.MODULE$.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_SPACE_BYTES()})));
            }
        }))).toLong();
    }

    private int getInitialDestinationFileId(Map<String, String> params) {
        return new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_INITIAL_FILE_ID(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing parameter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CobolBinaryFilesReplicator$.MODULE$.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_INITIAL_FILE_ID()})));
            }
        }))).toInt();
    }

    private int getMaxParallelReplicators(Map<String, String> params) {
        return new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_PARALLEL_REPLICATORS(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing parameter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CobolBinaryFilesReplicator$.MODULE$.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_PARALLEL_REPLICATORS()})));
            }
        }))).toInt();
    }

    private String getFilesSourceDirectory(Map<String, String> params) {
        return (String)params.getOrElse((Object)this.PARAM_SOURCE_DIR(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing parameter: PARAM_SOURCE_DIR"})).s((Seq)Nil$.MODULE$));
            }
        });
    }

    private String wrongParametersHelperMessage() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Usage parameters: ", "=dir_containing_files_to_replicate ", "=hdfs_destination_dir ", "=maximum_allowed_space_in_bytes ", "=maximum_number_of_replication_threads ", "=first_replicated_file_id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PARAM_SOURCE_DIR(), this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_DESTINATION_DIR(), this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_SPACE_BYTES(), this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_PARALLEL_REPLICATORS(), this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_INITIAL_FILE_ID()}));
    }

    private Configuration getConfiguration() {
        return new Configuration();
    }

    private void showConf(Configuration conf) {
        Iterator it = conf.iterator();
        while (it.hasNext()) {
            Predef$.MODULE$.println(it.next());
        }
    }

    private CobolBinaryFilesReplicator$() {
        MODULE$ = this;
        this.PARAM_SOURCE_DIR = "-DsourceDir";
        this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_DESTINATION_DIR = "-DdestinationDir";
        this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_SPACE_BYTES = "-DmaxSpaceBytes";
        this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_MAX_PARALLEL_REPLICATORS = "-DmaxParallelReplicators";
        this.za$co$absa$cobrix$spark$cobol$replication$CobolBinaryFilesReplicator$$PARAM_INITIAL_FILE_ID = "-DinitialFileId";
    }
}

