/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.replication.files.destination.generation;

import java.io.File;
import java.nio.file.Files;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.generation.HDFSFileWriter$;
import za.co.absa.cobrix.spark.cobol.replication.files.destination.identification.FileIdProvider;

@ScalaSignature(bytes="\u0006\u0001\u0005]u!B\u0001\u0003\u0011\u00039\u0012A\u0004%E\rN3\u0015\u000e\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t!bZ3oKJ\fG/[8o\u0015\t)a!A\u0006eKN$\u0018N\\1uS>t'BA\u0004\t\u0003\u00151\u0017\u000e\\3t\u0015\tI!\"A\u0006sKBd\u0017nY1uS>t'BA\u0006\r\u0003\u0015\u0019wNY8m\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u000511m\u001c2sSbT!!\u0005\n\u0002\t\u0005\u00147/\u0019\u0006\u0003'Q\t!aY8\u000b\u0003U\t!A_1\u0004\u0001A\u0011\u0001$G\u0007\u0002\u0005\u0019)!D\u0001E\u00017\tq\u0001\n\u0012$T\r&dWm\u0016:ji\u0016\u00148CA\r\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\")1%\u0007C\u0001I\u00051A(\u001b8jiz\"\u0012a\u0006\u0005\bMe\u0011\r\u0011\"\u0003(\u0003E9xN]6fe&#w)\u001a8fe\u0006$xN]\u000b\u0002QA\u0011\u0011FM\u0007\u0002U)\u00111\u0006L\u0001\u0007CR|W.[2\u000b\u00055r\u0013AC2p]\u000e,(O]3oi*\u0011q\u0006M\u0001\u0005kRLGNC\u00012\u0003\u0011Q\u0017M^1\n\u0005MR#!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u000463\u0001\u0006I\u0001K\u0001\u0013o>\u00148.\u001a:JI\u001e+g.\u001a:bi>\u0014\bE\u0002\u0003\u001b\u0005\u000194c\u0001\u001c9}A\u0011\u0011\bP\u0007\u0002u)\u00111\bM\u0001\u0005Y\u0006tw-\u0003\u0002>u\t1qJ\u00196fGR\u0004\"!O \n\u0005\u0001S$\u0001\u0003*v]:\f'\r\\3\t\u0011\t3$\u0011!Q\u0001\n\r\u000bq\u0001Z3ti\u0012K'\u000f\u0005\u0002E\u000f:\u0011Q$R\u0005\u0003\rz\ta\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aI\b\u0005\t\u000fY\u0012\t\u0011)A\u0005\u0017B\u0019Q\u0004\u0014(\n\u00055s\"!B!se\u0006L\bCA(S\u001b\u0005\u0001&BA)1\u0003\tIw.\u0003\u0002T!\n!a)\u001b7f\u0011!)fG!A!\u0002\u00131\u0016\u0001D7bqNK'0\u001a\"zi\u0016\u001c\bCA\u000fX\u0013\tAfD\u0001\u0003M_:<\u0007\u0002\u0003.7\u0005\u0003\u0005\u000b\u0011B.\u0002\u0011!$gm]\"p]\u001a\u0004\"\u0001X3\u000e\u0003uS!AX0\u0002\t\r|gN\u001a\u0006\u0003A\u0006\fa\u0001[1e_>\u0004(B\u00012d\u0003\u0019\t\u0007/Y2iK*\tA-A\u0002pe\u001eL!AZ/\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!AgG!A!\u0002\u0013I\u0017AC5e!J|g/\u001b3feB\u0011!.\\\u0007\u0002W*\u0011A\u000eB\u0001\u000fS\u0012,g\u000e^5gS\u000e\fG/[8o\u0013\tq7N\u0001\bGS2,\u0017\n\u001a)s_ZLG-\u001a:\t\u000b\r2D\u0011\u00019\u0015\rE\u00148\u000f^;w!\tAb\u0007C\u0003C_\u0002\u00071\tC\u0003\b_\u0002\u00071\nC\u0003V_\u0002\u0007a\u000bC\u0003[_\u0002\u00071\fC\u0003i_\u0002\u0007\u0011\u000eC\u0004ym\u0001\u0007I\u0011A=\u0002\u0011]|'o[3s\u0013\u0012,\u0012A\u001f\t\u0003;mL!\u0001 \u0010\u0003\u0007%sG\u000fC\u0004\u007fm\u0001\u0007I\u0011A@\u0002\u0019]|'o[3s\u0013\u0012|F%Z9\u0015\t\u0005\u0005\u0011q\u0001\t\u0004;\u0005\r\u0011bAA\u0003=\t!QK\\5u\u0011!\tI!`A\u0001\u0002\u0004Q\u0018a\u0001=%c!9\u0011Q\u0002\u001c!B\u0013Q\u0018!C<pe.,'/\u00133!\u0011%\t\tB\u000eb\u0001\n\u0007\t\u0019\"\u0001\u0003iI\u001a\u001cXCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e?\u0006\u0011am]\u0005\u0005\u0003?\tIB\u0001\u0006GS2,7+_:uK6D\u0001\"a\t7A\u0003%\u0011QC\u0001\u0006Q\u001247\u000f\t\u0005\n\u0003O1\u0004\u0019!C\u0005\u0003S\t\u0011\u0003^8uC2\u0014\u0015\u0010^3t/JLG\u000f^3o+\u00051\u0006\"CA\u0017m\u0001\u0007I\u0011BA\u0018\u0003U!x\u000e^1m\u0005f$Xm],sSR$XM\\0%KF$B!!\u0001\u00022!I\u0011\u0011BA\u0016\u0003\u0003\u0005\rA\u0016\u0005\b\u0003k1\u0004\u0015)\u0003W\u0003I!x\u000e^1m\u0005f$Xm],sSR$XM\u001c\u0011\t\u0011\u0005eb\u00071A\u0005\ne\f1BZ5mKB{\u0017N\u001c;fe\"I\u0011Q\b\u001cA\u0002\u0013%\u0011qH\u0001\u0010M&dW\rU8j]R,'o\u0018\u0013fcR!\u0011\u0011AA!\u0011%\tI!a\u000f\u0002\u0002\u0003\u0007!\u0010C\u0004\u0002FY\u0002\u000b\u0015\u0002>\u0002\u0019\u0019LG.\u001a)pS:$XM\u001d\u0011\t\u0011\u0005%c\u00071A\u0005\ne\fq\u0001]8j]R,'\u000fC\u0005\u0002NY\u0002\r\u0011\"\u0003\u0002P\u0005Y\u0001o\\5oi\u0016\u0014x\fJ3r)\u0011\t\t!!\u0015\t\u0013\u0005%\u00111JA\u0001\u0002\u0004Q\bbBA+m\u0001\u0006KA_\u0001\ta>Lg\u000e^3sA!9\u0011\u0011\f\u001c\u0005\u0002\u0005m\u0013a\u0001:v]R\u0011\u0011\u0011\u0001\u0005\b\u0003?2D\u0011BA1\u0003=9W\r\u001e(fqR4\u0015\u000e\\3QCRDGCAA2!\rI\u0014QM\u0005\u0003\u0011jBq!!\u001b7\t\u0013\tY'\u0001\nva\u0012\fG/\u001a\"zi\u0016\u001cxK]5ui\u0016tG\u0003BA\u0001\u0003[Bq!a\u001c\u0002h\u0001\u0007a+A\u0006mCN$xK]5ui\u0016t\u0007bBA:m\u0011%\u00111L\u0001\u0012kB$\u0017\r^3GS2,\u0007k\\5oi\u0016\u0014\bbBA<m\u0011%\u0011\u0011P\u0001\u0006oJLG/\u001a\u000b\u0007\u0003w\ny(a!\u0015\u0007Y\u000bi\b\u0003\u0005\u0002\u0012\u0005U\u00049AA\u000b\u0011\u001d\t\t)!\u001eA\u00029\u000bAAZ5mK\"9\u0011QQA;\u0001\u0004\u0019\u0015\u0001\u00033fgRt\u0015-\\3\t\u000f\u0005%e\u0007\"\u0003\u0002\f\u00069Ao\u001c\"zi\u0016\u001cH\u0003BAG\u0003+\u0003B!\b'\u0002\u0010B\u0019Q$!%\n\u0007\u0005MeD\u0001\u0003CsR,\u0007bBAA\u0003\u000f\u0003\rA\u0014")
public class HDFSFileWriter
implements Runnable {
    private final String destDir;
    private final File[] files;
    private final long maxSizeBytes;
    private final FileIdProvider idProvider;
    private int workerId;
    private final FileSystem hdfs;
    private long totalBytesWritten;
    private int filePointer;
    private int pointer;

    public int workerId() {
        return this.workerId;
    }

    public void workerId_$eq(int x$1) {
        this.workerId = x$1;
    }

    public FileSystem hdfs() {
        return this.hdfs;
    }

    private long totalBytesWritten() {
        return this.totalBytesWritten;
    }

    private void totalBytesWritten_$eq(long x$1) {
        this.totalBytesWritten = x$1;
    }

    private int filePointer() {
        return this.filePointer;
    }

    private void filePointer_$eq(int x$1) {
        this.filePointer = x$1;
    }

    private int pointer() {
        return this.pointer;
    }

    private void pointer_$eq(int x$1) {
        this.pointer = x$1;
    }

    @Override
    public void run() {
        while (this.totalBytesWritten() < this.maxSizeBytes) {
            String nextFilePath = this.getNextFilePath();
            long lastWritten = this.write(this.files[this.pointer()], nextFilePath, this.hdfs());
            if (lastWritten == 0L) {
                return;
            }
            this.updateBytesWritten(lastWritten);
            this.updateFilePointer();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Worker ", "]: wrote file: ", " (total bytes = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.workerId()), nextFilePath, BoxesRunTime.boxToLong((long)this.totalBytesWritten())})));
        }
    }

    private String getNextFilePath() {
        return new StringBuilder().append((Object)this.destDir).append((Object)"/part").append((Object)BoxesRunTime.boxToInteger((int)this.idProvider.getNextId())).append((Object)".bin").toString();
    }

    private void updateBytesWritten(long lastWritten) {
        this.totalBytesWritten_$eq(this.totalBytesWritten() + lastWritten);
    }

    private void updateFilePointer() {
        this.pointer_$eq(this.pointer() + 1);
        if (this.pointer() == this.files.length) {
            this.pointer_$eq(0);
        }
    }

    private long write(File file, String destName, FileSystem hdfs) {
        long l;
        try {
            FSDataOutputStream outstream = hdfs.create(new Path(destName), true);
            outstream.write(this.toBytes(file));
            outstream.flush();
            outstream.close();
            l = file.length();
        }
        catch (Exception exception) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing ", " to ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath(), destName, exception.getMessage()})));
            exception.printStackTrace();
            l = 0L;
        }
        return l;
    }

    private byte[] toBytes(File file) {
        return Files.readAllBytes(file.toPath());
    }

    public HDFSFileWriter(String destDir, File[] files, long maxSizeBytes, Configuration hdfsConf, FileIdProvider idProvider) {
        this.destDir = destDir;
        this.files = files;
        this.maxSizeBytes = maxSizeBytes;
        this.idProvider = idProvider;
        this.workerId = HDFSFileWriter$.MODULE$.za$co$absa$cobrix$spark$cobol$replication$files$destination$generation$HDFSFileWriter$$workerIdGenerator().incrementAndGet();
        this.hdfs = FileSystem.get((Configuration)hdfsConf);
        this.totalBytesWritten = 0L;
        this.filePointer = 0;
        this.pointer = 0;
    }
}

