/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.source.index;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import za.co.absa.cobrix.spark.cobol.reader.Constants$;
import za.co.absa.cobrix.spark.cobol.reader.Reader;
import za.co.absa.cobrix.spark.cobol.reader.index.entry.SparseIndexEntry;
import za.co.absa.cobrix.spark.cobol.reader.varlen.VarLenReader;
import za.co.absa.cobrix.spark.cobol.source.SerializableConfiguration;
import za.co.absa.cobrix.spark.cobol.source.index.IndexBuilder$;
import za.co.absa.cobrix.spark.cobol.source.index.IndexBuilder$$anonfun$1$;
import za.co.absa.cobrix.spark.cobol.source.index.LocationBalancer$;
import za.co.absa.cobrix.spark.cobol.source.parameters.LocalityParameters;
import za.co.absa.cobrix.spark.cobol.source.streaming.FileStreamer;
import za.co.absa.cobrix.spark.cobol.source.types.FileWithOrder;
import za.co.absa.cobrix.spark.cobol.utils.HDFSUtils$;
import za.co.absa.cobrix.spark.cobol.utils.SparkUtils$;

public final class IndexBuilder$ {
    public static final IndexBuilder$ MODULE$;
    private final Logger za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger;

    static {
        new IndexBuilder$();
    }

    public Logger za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger() {
        return this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger;
    }

    public RDD<SparseIndexEntry> buildIndex(FileWithOrder[] filesList, Reader cobolReader, SQLContext sqlContext, LocalityParameters localityParams) {
        VarLenReader varLenReader;
        Reader reader = cobolReader;
        RDD<SparseIndexEntry> rDD = reader instanceof VarLenReader ? ((varLenReader = (VarLenReader)reader).isIndexGenerationNeeded() && localityParams.improveLocality() ? this.buildIndexForVarLenReaderWithFullLocality(filesList, varLenReader, sqlContext, localityParams.optimizeAllocation()) : this.buildIndexForVarLenReader(filesList, varLenReader, sqlContext)) : null;
        return rDD;
    }

    private RDD<SparseIndexEntry> buildIndexForVarLenReaderWithFullLocality(FileWithOrder[] filesList, VarLenReader reader, SQLContext sqlContext, boolean optimizeAllocation) {
        Configuration conf = sqlContext.sparkContext().hadoopConfiguration();
        RDD<FileWithOrder> filesRDD = this.toRDDWithLocality(filesList, conf, sqlContext);
        SerializableConfiguration sconf = new SerializableConfiguration(conf);
        RDD indexes = filesRDD.mapPartitions((Function1)new Serializable(reader, sconf){
            public static final long serialVersionUID = 0L;
            public final VarLenReader reader$1;
            private final SerializableConfiguration sconf$1;

            public final Iterator<Tuple2<SparseIndexEntry, Seq<String>>> apply(Iterator<FileWithOrder> partition) {
                FileSystem fileSystem = FileSystem.get((Configuration)this.sconf$1.value());
                return partition.flatMap((Function1)new Serializable(this, fileSystem){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    public final FileSystem fileSystem$1;

                    public final ArrayBuffer<Tuple2<SparseIndexEntry, Seq<String>>> apply(FileWithOrder row) {
                        String filePath = row.filePath();
                        int fileOrder = row.order();
                        IndexBuilder$.MODULE$.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Going to generate index for the file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
                        ArrayBuffer<SparseIndexEntry> index = this.$outer.reader$1.generateIndex(new FileStreamer(filePath, this.fileSystem$1, 0L, 0L), fileOrder, this.$outer.reader$1.isRdwBigEndian());
                        return (ArrayBuffer)index.map((Function1)new Serializable(this, filePath){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$1$$anonfun$apply$1 $outer;
                            private final String filePath$1;

                            public final Tuple2<SparseIndexEntry, Seq<String>> apply(SparseIndexEntry entry) {
                                long offset = entry.offsetFrom() >= 0L ? entry.offsetFrom() : 0L;
                                long length = IndexBuilder$.MODULE$.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$getBlockLengthByIndexEntry(entry);
                                return new Tuple2((Object)entry, HDFSUtils$.MODULE$.getBlocksLocations(new Path(this.filePath$1), offset, length, this.$outer.fileSystem$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.filePath$1 = filePath$1;
                            }
                        }, ArrayBuffer$.MODULE$.canBuildFrom());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fileSystem$1 = fileSystem$1;
                    }
                });
            }
            {
                this.reader$1 = reader$1;
                this.sconf$1 = sconf$1;
            }
        }, filesRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().info("Going to collect located indexes into driver.");
        Seq<Tuple2<SparseIndexEntry, Seq<String>>> offsetsLocations = optimizeAllocation ? this.optimizeDistribution((Seq<Tuple2<SparseIndexEntry, Seq<String>>>)Predef$.MODULE$.wrapRefArray((Object[])indexes.collect()), sqlContext.sparkContext()) : Predef$.MODULE$.wrapRefArray((Object[])indexes.collect());
        this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating RDD for ", " located indexes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offsetsLocations.length())})));
        if (this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().isDebugEnabled()) {
            this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().debug("Preferred locations per index entry");
            offsetsLocations.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<SparseIndexEntry, Seq<String>> allocation) {
                    IndexBuilder$.MODULE$.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().debug(allocation.toString());
                }
            });
        }
        return sqlContext.sparkContext().makeRDD(offsetsLocations, ClassTag$.MODULE$.apply(SparseIndexEntry.class));
    }

    public long za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$getBlockLengthByIndexEntry(SparseIndexEntry entry) {
        long indexedLength = entry.offsetTo() > 0L ? entry.offsetTo() : Long.MAX_VALUE;
        long significantLength = indexedLength < 10L * (long)Constants$.MODULE$.megabyte() ? indexedLength : indexedLength - (long)Constants$.MODULE$.megabyte();
        return significantLength;
    }

    private Seq<Tuple2<SparseIndexEntry, Seq<String>>> optimizeDistribution(Seq<Tuple2<SparseIndexEntry, Seq<String>>> allocation, SparkContext sc) {
        Seq<String> availableExecutors = SparkUtils$.MODULE$.currentActiveExecutors(sc);
        this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to balance ", " partitions among all available executors (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)allocation.size()), availableExecutors})));
        return LocationBalancer$.MODULE$.balance(allocation, availableExecutors);
    }

    private RDD<FileWithOrder> toRDDWithLocality(FileWithOrder[] filesList, Configuration conf, SQLContext sqlContext) {
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        Seq filesWithPreferredLocations = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filesList).map((Function1)new Serializable(fileSystem){
            public static final long serialVersionUID = 0L;
            private final FileSystem fileSystem$2;

            public final Tuple2<FileWithOrder, Seq<String>> apply(FileWithOrder file) {
                return new Tuple2((Object)file, HDFSUtils$.MODULE$.getBlocksLocations(new Path(file.filePath()), this.fileSystem$2));
            }
            {
                this.fileSystem$2 = fileSystem$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSeq();
        filesWithPreferredLocations.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<FileWithOrder, Seq<String>> a) {
                IndexBuilder$.MODULE$.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().debug(a.toString());
            }
        });
        return sqlContext.sparkContext().makeRDD(filesWithPreferredLocations, ClassTag$.MODULE$.apply(FileWithOrder.class));
    }

    public RDD<SparseIndexEntry> buildIndexForVarLenReader(FileWithOrder[] filesList, VarLenReader reader, SQLContext sqlContext) {
        RDD filesRDD = sqlContext.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])filesList), filesList.length, ClassTag$.MODULE$.apply(FileWithOrder.class));
        Configuration conf = sqlContext.sparkContext().hadoopConfiguration();
        SerializableConfiguration sconf = new SerializableConfiguration(conf);
        RDD indexes = filesRDD.mapPartitions((Function1)new Serializable(reader, sconf){
            public static final long serialVersionUID = 0L;
            public final VarLenReader reader$2;
            private final SerializableConfiguration sconf$2;

            public final Iterator<SparseIndexEntry> apply(Iterator<FileWithOrder> partition) {
                FileSystem fileSystem = FileSystem.get((Configuration)this.sconf$2.value());
                return partition.flatMap((Function1)new Serializable(this, fileSystem){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    private final FileSystem fileSystem$3;

                    public final ArrayBuffer<SparseIndexEntry> apply(FileWithOrder row) {
                        String filePath = row.filePath();
                        int fileOrder = row.order();
                        IndexBuilder$.MODULE$.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Going to generate index for the file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
                        ArrayBuffer<SparseIndexEntry> index = this.$outer.reader$2.generateIndex(new FileStreamer(filePath, this.fileSystem$3, 0L, 0L), fileOrder, this.$outer.reader$2.isRdwBigEndian());
                        return index;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fileSystem$3 = fileSystem$3;
                    }
                });
            }
            {
                this.reader$2 = reader$2;
                this.sconf$2 = sconf$2;
            }
        }, filesRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SparseIndexEntry.class)).cache();
        long indexCount = indexes.count();
        int numPartitions = (int)Math.min(indexCount, (long)Constants$.MODULE$.maxNumPartitions());
        this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index elements count: ", ", number of partitions = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)indexCount), BoxesRunTime.boxToInteger((int)numPartitions)})));
        int x$1 = numPartitions;
        Ordering x$2 = indexes.repartition$default$2(x$1);
        return indexes.repartition(x$1, x$2).cache();
    }

    private IndexBuilder$() {
        MODULE$ = this;
        this.za$co$absa$cobrix$spark$cobol$source$index$IndexBuilder$$logger = LoggerFactory.getLogger(this.getClass());
    }
}

