/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.source.scanners;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import za.co.absa.cobrix.spark.cobol.reader.Constants$;
import za.co.absa.cobrix.spark.cobol.reader.fixedlen.FixedLenReader;
import za.co.absa.cobrix.spark.cobol.reader.index.entry.SparseIndexEntry;
import za.co.absa.cobrix.spark.cobol.reader.varlen.VarLenReader;
import za.co.absa.cobrix.spark.cobol.source.SerializableConfiguration;
import za.co.absa.cobrix.spark.cobol.source.scanners.CobolScanners$;
import za.co.absa.cobrix.spark.cobol.source.streaming.FileStreamer;
import za.co.absa.cobrix.spark.cobol.source.streaming.FileStreamer$;
import za.co.absa.cobrix.spark.cobol.source.types.FileWithOrder;

public final class CobolScanners$ {
    public static final CobolScanners$ MODULE$;
    private final Logger za$co$absa$cobrix$spark$cobol$source$scanners$CobolScanners$$logger;

    static {
        new CobolScanners$();
    }

    public Logger za$co$absa$cobrix$spark$cobol$source$scanners$CobolScanners$$logger() {
        return this.za$co$absa$cobrix$spark$cobol$source$scanners$CobolScanners$$logger;
    }

    public RDD<Row> buildScanForVarLenIndex(VarLenReader reader, RDD<SparseIndexEntry> indexes, FileWithOrder[] filesList, SQLContext sqlContext) {
        Map filesMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filesList).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(FileWithOrder fileWithOrder) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)fileWithOrder.order()), (Object)fileWithOrder.filePath());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Configuration conf = sqlContext.sparkContext().hadoopConfiguration();
        SerializableConfiguration sconf = new SerializableConfiguration(conf);
        return indexes.flatMap((Function1)new Serializable(reader, filesMap, sconf){
            public static final long serialVersionUID = 0L;
            private final VarLenReader reader$1;
            private final Map filesMap$1;
            private final SerializableConfiguration sconf$1;

            public final Iterator<Row> apply(SparseIndexEntry indexEntry) {
                FileSystem fileSystem = FileSystem.get((Configuration)this.sconf$1.value());
                String filePathName = (String)this.filesMap$1.apply((Object)BoxesRunTime.boxToInteger((int)indexEntry.fileId()));
                String fileName = new Path(filePathName).getName();
                long numOfBytes = indexEntry.offsetTo() > 0L ? indexEntry.offsetTo() - indexEntry.offsetFrom() : 0L;
                String numOfBytesMsg = numOfBytes > 0L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " MB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(numOfBytes / (long)Constants$.MODULE$.megabyte()))})) : "until the end";
                CobolScanners$.MODULE$.za$co$absa$cobrix$spark$cobol$source$scanners$CobolScanners$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Going to process offsets ", "...", " (", ") of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)indexEntry.offsetFrom()), BoxesRunTime.boxToLong((long)indexEntry.offsetTo()), numOfBytesMsg, fileName})));
                FileStreamer dataStream = new FileStreamer(filePathName, fileSystem, indexEntry.offsetFrom(), numOfBytes);
                return this.reader$1.getRowIterator(dataStream, indexEntry.offsetFrom(), indexEntry.fileId(), indexEntry.recordIndex());
            }
            {
                this.reader$1 = reader$1;
                this.filesMap$1 = filesMap$1;
                this.sconf$1 = sconf$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> buildScanForVariableLength(VarLenReader reader, FileWithOrder[] filesList, SQLContext sqlContext) {
        RDD filesRDD = sqlContext.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])filesList), filesList.length, ClassTag$.MODULE$.apply(FileWithOrder.class));
        Configuration conf = sqlContext.sparkContext().hadoopConfiguration();
        SerializableConfiguration sconf = new SerializableConfiguration(conf);
        return filesRDD.mapPartitions((Function1)new Serializable(reader, sconf){
            public static final long serialVersionUID = 0L;
            public final VarLenReader reader$2;
            private final SerializableConfiguration sconf$2;

            public final Iterator<Row> apply(Iterator<FileWithOrder> partition) {
                FileSystem fileSystem = FileSystem.get((Configuration)this.sconf$2.value());
                return partition.flatMap((Function1)new Serializable(this, fileSystem){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.buildScanForVariableLength.1 $outer;
                    private final FileSystem fileSystem$1;

                    public final Iterator<Row> apply(FileWithOrder row) {
                        String filePath = row.filePath();
                        int fileOrder = row.order();
                        CobolScanners$.MODULE$.za$co$absa$cobrix$spark$cobol$source$scanners$CobolScanners$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Going to parse file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
                        return this.$outer.reader$2.getRowIterator(new FileStreamer(filePath, this.fileSystem$1, FileStreamer$.MODULE$.$lessinit$greater$default$3(), FileStreamer$.MODULE$.$lessinit$greater$default$4()), 0L, fileOrder, 0L);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fileSystem$1 = fileSystem$1;
                    }
                });
            }
            {
                this.reader$2 = reader$2;
                this.sconf$2 = sconf$2;
            }
        }, filesRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> buildScanForFixedLength(FixedLenReader reader, String sourceDir, Function2<FixedLenReader, RDD<byte[]>, RDD<Row>> recordParser, SQLContext sqlContext) {
        int recordSize = reader.getCobolSchema().getRecordSize() + reader.getRecordStartOffset() + reader.getRecordEndOffset();
        StructType schema = reader.getSparkSchema();
        RDD records = sqlContext.sparkContext().binaryRecords(sourceDir, recordSize, sqlContext.sparkContext().hadoopConfiguration());
        return (RDD)recordParser.apply((Object)reader, (Object)records);
    }

    private CobolScanners$() {
        MODULE$ = this;
        this.za$co$absa$cobrix$spark$cobol$source$scanners$CobolScanners$$logger = LoggerFactory.getLogger(this.getClass());
    }
}

