/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.source.streaming;

import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001M\u0011\u0011DQ;gM\u0016\u0014X\r\u001a$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[*\u00111\u0001B\u0001\ngR\u0014X-Y7j]\u001eT!!\u0002\u0004\u0002\rM|WO]2f\u0015\t9\u0001\"A\u0003d_\n|GN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007G>\u0014'/\u001b=\u000b\u00055q\u0011\u0001B1cg\u0006T!a\u0004\t\u0002\u0005\r|'\"A\t\u0002\u0005i\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"!\b\u0014\u000e\u0003yQ!a\b\u0011\u0002\u0005\u0019\u001c(BA\u0011#\u0003\u0019A\u0017\rZ8pa*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0013\t9cD\u0001\u0003QCRD\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0015\u0019LG.Z*zgR,W\u000e\u0005\u0002\u001eW%\u0011AF\b\u0002\u000b\r&dWmU=ti\u0016l\u0007\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0003+AJ!!\r\f\u0003\t1{gn\u001a\u0005\tg\u0001\u0011\t\u0011)A\u0005i\u0005)\"-\u001e4gKJ\u001c\u0016N_3J]6+w-\u00192zi\u0016\u001c\bCA\u000b6\u0013\t1dCA\u0002J]RD\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006IaL\u0001\r[\u0006D\u0018.\\;n\u0005f$Xm\u001d\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\rqrt\bQ!C!\ti\u0004!D\u0001\u0003\u0011\u0015Y\u0012\b1\u0001\u001d\u0011\u0015I\u0013\b1\u0001+\u0011\u0015q\u0013\b1\u00010\u0011\u0015\u0019\u0014\b1\u00015\u0011\u0015A\u0014\b1\u00010\u0011\u001d!\u0005A1A\u0005\u0002\u0015\u000bqBY=uKNLe.T3hC\nLH/Z\u000b\u0002i!1q\t\u0001Q\u0001\nQ\n\u0001CY=uKNLe.T3hC\nLH/\u001a\u0011\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\u0006\u0011\u0011N\\\u000b\u0002\u0017B\u0011Q\u0004T\u0005\u0003\u001bz\u0011\u0011CR*ECR\f\u0017J\u001c9viN#(/Z1n\u0011\u001dy\u0005\u00011A\u0005\u0002A\u000ba!\u001b8`I\u0015\fHCA)U!\t)\"+\u0003\u0002T-\t!QK\\5u\u0011\u001d)f*!AA\u0002-\u000b1\u0001\u001f\u00132\u0011\u00199\u0006\u0001)Q\u0005\u0017\u0006\u0019\u0011N\u001c\u0011\t\u000fe\u0003!\u0019!C\u0005\u000b\u0006\t\"-\u001e4gKJ\u001c\u0016N_3J]\nKH/Z:\t\rm\u0003\u0001\u0015!\u00035\u0003I\u0011WO\u001a4feNK'0Z%o\u0005f$Xm\u001d\u0011\t\u000fu\u0003\u0001\u0019!C\u0005=\u0006q\u0011n]*ue\u0016\fWn\u00117pg\u0016$W#A0\u0011\u0005U\u0001\u0017BA1\u0017\u0005\u001d\u0011un\u001c7fC:Dqa\u0019\u0001A\u0002\u0013%A-\u0001\njgN#(/Z1n\u00072|7/\u001a3`I\u0015\fHCA)f\u0011\u001d)&-!AA\u0002}Caa\u001a\u0001!B\u0013y\u0016aD5t'R\u0014X-Y7DY>\u001cX\r\u001a\u0011\t\u000f%\u0004!\u0019!C\u0005U\u00061!-\u001e4gKJ,\u0012a\u001b\t\u0004+1t\u0017BA7\u0017\u0005\u0015\t%O]1z!\t)r.\u0003\u0002q-\t!!)\u001f;f\u0011\u0019\u0011\b\u0001)A\u0005W\u00069!-\u001e4gKJ\u0004\u0003b\u0002;\u0001\u0001\u0004%I!R\u0001\nEV4g-\u001a:Q_NDqA\u001e\u0001A\u0002\u0013%q/A\u0007ck\u001a4WM\u001d)pg~#S-\u001d\u000b\u0003#bDq!V;\u0002\u0002\u0003\u0007A\u0007\u0003\u0004{\u0001\u0001\u0006K\u0001N\u0001\u000bEV4g-\u001a:Q_N\u0004\u0003b\u0002?\u0001\u0001\u0004%I!R\u0001\u0014EV4g-\u001a:D_:LG/Y5o\u0005f$Xm\u001d\u0005\b}\u0002\u0001\r\u0011\"\u0003\u0000\u0003]\u0011WO\u001a4fe\u000e{g.\u001b;bS:\u0014\u0015\u0010^3t?\u0012*\u0017\u000fF\u0002R\u0003\u0003Aq!V?\u0002\u0002\u0003\u0007A\u0007C\u0004\u0002\u0006\u0001\u0001\u000b\u0015\u0002\u001b\u0002)\t,hMZ3s\u0007>t\u0017\u000e^1j]\nKH/Z:!\u0011!\tI\u0001\u0001a\u0001\n\u0013)\u0015!\u00032zi\u0016\u001c(+Z1e\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty!A\u0007csR,7OU3bI~#S-\u001d\u000b\u0004#\u0006E\u0001\u0002C+\u0002\f\u0005\u0005\t\u0019\u0001\u001b\t\u000f\u0005U\u0001\u0001)Q\u0005i\u0005Q!-\u001f;fgJ+\u0017\r\u001a\u0011\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u0005)1\r\\8tKR\t\u0011\u000b\u0003\u0004\u0002 \u0001!\tAX\u0001\tSN\u001cEn\\:fI\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012!\u0003:fC\u00124U\u000f\u001c7z)\u001d!\u0014qEA\u0016\u0003_Aq!!\u000b\u0002\"\u0001\u00071.A\u0001c\u0011\u001d\ti#!\tA\u0002Q\n1a\u001c4g\u0011\u001d\t\t$!\tA\u0002Q\n1\u0001\\3o\u0011\u001d\t)\u0004\u0001C\u0005\u0003o\tqB]3bI\u001a+H\u000e\\=IK2\u0004XM\u001d\u000b\bi\u0005e\u00121HA\u001f\u0011\u001d\tI#a\rA\u0002-Dq!!\f\u00024\u0001\u0007A\u0007C\u0004\u00022\u0005M\u0002\u0019\u0001\u001b")
public class BufferedFSDataInputStream {
    private final long maximumBytes;
    private final int bytesInMegabyte;
    private FSDataInputStream in;
    private final int bufferSizeInBytes;
    private boolean isStreamClosed;
    private final byte[] buffer;
    private int bufferPos;
    private int bufferConitainBytes;
    private int bytesRead;

    public int bytesInMegabyte() {
        return this.bytesInMegabyte;
    }

    public FSDataInputStream in() {
        return this.in;
    }

    public void in_$eq(FSDataInputStream x$1) {
        this.in = x$1;
    }

    private int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    private boolean isStreamClosed() {
        return this.isStreamClosed;
    }

    private void isStreamClosed_$eq(boolean x$1) {
        this.isStreamClosed = x$1;
    }

    private byte[] buffer() {
        return this.buffer;
    }

    private int bufferPos() {
        return this.bufferPos;
    }

    private void bufferPos_$eq(int x$1) {
        this.bufferPos = x$1;
    }

    private int bufferConitainBytes() {
        return this.bufferConitainBytes;
    }

    private void bufferConitainBytes_$eq(int x$1) {
        this.bufferConitainBytes = x$1;
    }

    private int bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(int x$1) {
        this.bytesRead = x$1;
    }

    public void close() {
        if (!this.isStreamClosed()) {
            this.in().close();
            this.in_$eq(null);
            this.isStreamClosed_$eq(true);
        }
    }

    public boolean isClosed() {
        return this.isStreamClosed() && this.bufferPos() >= this.bufferConitainBytes();
    }

    public int readFully(byte[] b, int off, int len) {
        int n;
        if (this.isClosed()) {
            n = -1;
        } else if (this.bufferPos() + len < this.bufferConitainBytes()) {
            System.arraycopy(this.buffer(), this.bufferPos(), b, off, len);
            this.bufferPos_$eq(this.bufferPos() + len);
            n = len;
        } else {
            int n2;
            int offsetLeft = off;
            int lengthLeft = len;
            if (this.bufferPos() < this.bufferConitainBytes()) {
                int bytesLeft = this.bufferConitainBytes() - this.bufferPos();
                System.arraycopy(this.buffer(), this.bufferPos(), b, off, bytesLeft);
                lengthLeft -= this.bufferConitainBytes() - this.bufferPos();
                offsetLeft += bytesLeft;
            }
            this.bufferPos_$eq(0);
            if (this.maximumBytes > 0L && (long)this.bytesRead() >= this.maximumBytes || this.isStreamClosed()) {
                this.close();
                n2 = 0;
            } else {
                long toRead = this.maximumBytes > 0L ? Math.min((long)this.bufferSizeInBytes(), this.maximumBytes - (long)this.bytesRead()) : (long)this.bufferSizeInBytes();
                n2 = this.readFullyHelper(this.buffer(), 0, this.bufferSizeInBytes());
            }
            this.bufferConitainBytes_$eq(n2);
            this.bytesRead_$eq(this.bytesRead() + this.bufferConitainBytes());
            if (this.bufferConitainBytes() > 0) {
                if (this.bufferPos() + lengthLeft < this.bufferConitainBytes()) {
                    System.arraycopy(this.buffer(), this.bufferPos(), b, offsetLeft, lengthLeft);
                    this.bufferPos_$eq(this.bufferPos() + lengthLeft);
                    offsetLeft += lengthLeft;
                    lengthLeft = 0;
                } else if (this.bufferConitainBytes() > 0) {
                    System.arraycopy(this.buffer(), this.bufferPos(), b, offsetLeft, lengthLeft);
                    this.bufferPos_$eq(this.bufferPos() + this.bufferConitainBytes());
                    offsetLeft += this.bufferConitainBytes();
                    lengthLeft -= this.bufferConitainBytes();
                }
            }
            n = len - lengthLeft;
        }
        return n;
    }

    private int readFullyHelper(byte[] b, int off, int len) {
        int n;
        if (len <= 0) {
            n = len;
        } else {
            int n2 = 0;
            int count = 0;
            while (n2 < len && count >= 0) {
                count = this.in().read(b, off + n2, len - n2);
                if (count >= 0) {
                    n2 += count;
                    continue;
                }
                this.close();
            }
            n = n2;
        }
        return n;
    }

    public BufferedFSDataInputStream(Path filePath, FileSystem fileSystem, long startOffset, int bufferSizeInMegabytes, long maximumBytes) {
        this.maximumBytes = maximumBytes;
        this.bytesInMegabyte = 0x100000;
        if (bufferSizeInMegabytes <= 0 || bufferSizeInMegabytes > 1000) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid buffer size ", " MB."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bufferSizeInMegabytes)})));
        }
        this.in = fileSystem.open(filePath);
        if (startOffset > 0L) {
            this.in().seek(startOffset);
        }
        this.bufferSizeInBytes = bufferSizeInMegabytes * this.bytesInMegabyte();
        this.isStreamClosed = this.in() == null;
        this.buffer = new byte[this.bufferSizeInBytes()];
        this.bufferPos = 0;
        this.bufferConitainBytes = 0;
        this.bytesRead = 0;
    }
}

