/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.source.streaming;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import za.co.absa.cobrix.cobol.parser.stream.SimpleStream;
import za.co.absa.cobrix.spark.cobol.reader.Constants$;
import za.co.absa.cobrix.spark.cobol.source.streaming.BufferedFSDataInputStream;
import za.co.absa.cobrix.spark.cobol.source.streaming.FileStreamer$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001M\u0011ABR5mKN#(/Z1nKJT!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003\u0019\u0019x.\u001e:dK*\u0011q\u0001C\u0001\u0006G>\u0014w\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\r|'M]5y\u0015\tia\"\u0001\u0003bEN\f'BA\b\u0011\u0003\t\u0019wNC\u0001\u0012\u0003\tQ\u0018m\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037\u0005j\u0011\u0001\b\u0006\u0003;y\taa\u001d;sK\u0006l'BA\u0010!\u0003\u0019\u0001\u0018M]:fe*\u0011qAC\u0005\u0003Eq\u0011AbU5na2,7\u000b\u001e:fC6D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\tM&dW\rU1uQB\u0011a%\u000b\b\u0003+\u001dJ!\u0001\u000b\f\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003QYA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0001\u000bM&dWmU=ti\u0016l\u0007CA\u00189\u001b\u0005\u0001$BA\u00193\u0003\t17O\u0003\u00024i\u00051\u0001.\u00193p_BT!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO&\u0011\u0011\b\r\u0002\u000b\r&dWmU=ti\u0016l\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0003+uJ!A\u0010\f\u0003\t1{gn\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005y\u0005aQ.\u0019=j[Vl')\u001f;fg\")!\t\u0001C\u0001\u0007\u00061A(\u001b8jiz\"R\u0001\u0012$H\u0011&\u0003\"!\u0012\u0001\u000e\u0003\tAQ\u0001J!A\u0002\u0015BQ!L!A\u00029BqaO!\u0011\u0002\u0003\u0007A\bC\u0004A\u0003B\u0005\t\u0019\u0001\u001f\t\u000f-\u0003!\u0019!C\u0005\u0019\u00061An\\4hKJ,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!R\nQ\u0001\\8hi)L!AU(\u0003\r1{wmZ3s\u0011\u0019!\u0006\u0001)A\u0005\u001b\u00069An\\4hKJ\u0004\u0003b\u0002,\u0001\u0001\u0004%IaV\u0001\u0007_\u001a47/\u001a;\u0016\u0003qBq!\u0017\u0001A\u0002\u0013%!,\u0001\u0006pM\u001a\u001cX\r^0%KF$\"a\u00170\u0011\u0005Ua\u0016BA/\u0017\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001y\u0005\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u0003=\u0003\u001dygMZ:fi\u0002Bqa\u0019\u0001A\u0002\u0013%A-\u0001\bck\u001a,'O]3e'R\u0014X-Y7\u0016\u0003\u0015\u0004\"!\u00124\n\u0005\u001d\u0014!!\u0007\"vM\u001a,'/\u001a3G'\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6Dq!\u001b\u0001A\u0002\u0013%!.\u0001\nck\u001a,'O]3e'R\u0014X-Y7`I\u0015\fHCA.l\u0011\u001dy\u0006.!AA\u0002\u0015Da!\u001c\u0001!B\u0013)\u0017a\u00042vM\u0016\u0014(/\u001a3TiJ,\u0017-\u001c\u0011\t\u000b=\u0004A\u0011\t9\u0002\t9,\u0007\u0010\u001e\u000b\u0003c^\u00042!\u0006:u\u0013\t\u0019hCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0016k&\u0011aO\u0006\u0002\u0005\u0005f$X\rC\u0003y]\u0002\u0007\u00110A\u0007ok6\u0014WM](g\u0005f$Xm\u001d\t\u0003+iL!a\u001f\f\u0003\u0007%sG\u000fC\u0003~\u0001\u0011\u0005c0A\u0003dY>\u001cX\rF\u0001\\\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\t1bZ3u\u0011\u001235\u000bU1uQR!\u0011QAA\u0006!\ry\u0013qA\u0005\u0004\u0003\u0013\u0001$\u0001\u0002)bi\"Da!!\u0004\u0000\u0001\u0004)\u0013\u0001\u00029bi\"<\u0011\"!\u0005\u0003\u0003\u0003E\t!a\u0005\u0002\u0019\u0019KG.Z*ue\u0016\fW.\u001a:\u0011\u0007\u0015\u000b)B\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\f'\r\t)\u0002\u0006\u0005\b\u0005\u0006UA\u0011AA\u000e)\t\t\u0019\u0002\u0003\u0006\u0002 \u0005U\u0011\u0013!C\u0001\u0003C\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA\u0012U\ra\u0014QE\u0016\u0003\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0007\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00026\u0005-\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011\u0011HA\u000b#\u0003%\t!!\t\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class FileStreamer
implements SimpleStream {
    private final FileSystem fileSystem;
    private final long startOffset;
    private final long maximumBytes;
    private final Logger logger;
    private long offset;
    private BufferedFSDataInputStream buferredStream;

    public static long $lessinit$greater$default$4() {
        return FileStreamer$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return FileStreamer$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger() {
        return this.logger;
    }

    private long offset() {
        return this.offset;
    }

    private void offset_$eq(long x$1) {
        this.offset = x$1;
    }

    private BufferedFSDataInputStream buferredStream() {
        return this.buferredStream;
    }

    private void buferredStream_$eq(BufferedFSDataInputStream x$1) {
        this.buferredStream = x$1;
    }

    public byte[] next(int numberOfBytes) {
        byte[] byArray;
        if (this.maximumBytes > 0L && this.offset() - this.startOffset >= this.maximumBytes || this.buferredStream().isClosed()) {
            this.close();
            byArray = new byte[]{};
        } else {
            byte[] buffer = new byte[numberOfBytes];
            int readBytes = this.buferredStream().readFully(buffer, 0, numberOfBytes);
            if (readBytes > 0) {
                this.offset_$eq(this.offset() + (long)readBytes);
            }
            if (readBytes == numberOfBytes) {
                byArray = buffer;
            } else {
                this.logger().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End of stream reached: Requested ", " bytes, received ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numberOfBytes), BoxesRunTime.boxToInteger((int)readBytes)})));
                this.close();
                if (readBytes > 0) {
                    byte[] shrunkBuffer = new byte[readBytes];
                    System.arraycopy(buffer, 0, shrunkBuffer, 0, readBytes);
                    byArray = shrunkBuffer;
                } else {
                    byArray = new byte[]{};
                }
            }
        }
        return byArray;
    }

    public void close() {
        if (!this.buferredStream().isClosed()) {
            this.buferredStream().close();
            this.buferredStream_$eq(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Path getHDFSPath(String path) {
        if (this.fileSystem == null) {
            throw new IllegalArgumentException("Null FileSystem instance.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null input file.");
        }
        Path hdfsPath = new Path(path);
        if (this.fileSystem.exists(hdfsPath)) {
            void var2_2;
            return var2_2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inexistent file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
    }

    public FileStreamer(String filePath, FileSystem fileSystem, long startOffset, long maximumBytes) {
        this.fileSystem = fileSystem;
        this.startOffset = startOffset;
        this.maximumBytes = maximumBytes;
        this.logger = Logger.getLogger(this.getClass());
        this.offset = startOffset;
        this.buferredStream = new BufferedFSDataInputStream(this.getHDFSPath(filePath), fileSystem, startOffset, Constants$.MODULE$.defaultStreamBufferInMB(), maximumBytes);
    }
}

