/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.cobrix.spark.cobol.utils;

import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HDFSUtils$ {
    public static final HDFSUtils$ MODULE$;
    private final int bytesInMegabyte;

    static {
        new HDFSUtils$();
    }

    public final int bytesInMegabyte() {
        return 0x100000;
    }

    public Seq<String> getBlocksLocations(Path path, FileSystem fileSystem) {
        return this.getBlocksLocations(path, 0L, Long.MAX_VALUE, fileSystem);
    }

    public Seq<String> getBlocksLocations(Path path, long start, long length, FileSystem fileSystem) {
        if (start < 0L || length <= 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid offset or length: offset = ", ", length = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)length)})));
        }
        if (fileSystem.isDirectory(path)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should be a file, not a directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getName()})));
        }
        return Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fileSystem.getFileBlockLocations(fileSystem.getFileStatus(path), start, length)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(BlockLocation x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.getHosts());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct());
    }

    public Option<Object> getHDFSDefaultBlockSizeMB(FileSystem fileSystem, Option<String> path) {
        int blockSizeInBM;
        Path hdfsPath = new Path((String)path.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "/";
            }
        }));
        long blockSizeInBytes = fileSystem.getDefaultBlockSize(hdfsPath);
        return blockSizeInBytes > 0L ? ((blockSizeInBM = (int)(blockSizeInBytes / 0x100000L)) > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)blockSizeInBM)) : None$.MODULE$) : None$.MODULE$;
    }

    public Option<String> getHDFSDefaultBlockSizeMB$default$2() {
        return None$.MODULE$;
    }

    private HDFSUtils$() {
        MODULE$ = this;
    }
}

