/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.intercept.web;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.intercept.web.AbstractFilterInvocationDefinitionSource;
import net.sf.acegisecurity.intercept.web.FilterInvocationDefinitionMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RegExpBasedFilterInvocationDefinitionMap
extends AbstractFilterInvocationDefinitionSource
implements FilterInvocationDefinitionMap {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap == null ? (class$net$sf$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap = RegExpBasedFilterInvocationDefinitionMap.class$("net.sf.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap")) : class$net$sf$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap));
    private List requestMap = new Vector();
    private boolean convertUrlToLowercaseBeforeComparison = false;
    static /* synthetic */ Class class$net$sf$acegisecurity$intercept$web$RegExpBasedFilterInvocationDefinitionMap;

    public Iterator getConfigAttributeDefinitions() {
        HashSet<ConfigAttributeDefinition> set = new HashSet<ConfigAttributeDefinition>();
        Iterator iter = this.requestMap.iterator();
        while (iter.hasNext()) {
            EntryHolder entryHolder = (EntryHolder)iter.next();
            set.add(entryHolder.getConfigAttributeDefinition());
        }
        return set.iterator();
    }

    public void setConvertUrlToLowercaseBeforeComparison(boolean convertUrlToLowercaseBeforeComparison) {
        this.convertUrlToLowercaseBeforeComparison = convertUrlToLowercaseBeforeComparison;
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.convertUrlToLowercaseBeforeComparison;
    }

    public int getMapSize() {
        return this.requestMap.size();
    }

    public void addSecureUrl(String perl5RegExp, ConfigAttributeDefinition attr) {
        Pattern compiledPattern;
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            compiledPattern = compiler.compile(perl5RegExp, 32768);
        }
        catch (MalformedPatternException mpe) {
            throw new IllegalArgumentException("Malformed regular expression: " + perl5RegExp);
        }
        this.requestMap.add(new EntryHolder(compiledPattern, attr));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added regular expression: " + compiledPattern.getPattern().toString() + "; attributes: " + attr.toString()));
        }
    }

    public ConfigAttributeDefinition lookupAttributes(String url) {
        Perl5Matcher matcher = new Perl5Matcher();
        Iterator iter = this.requestMap.iterator();
        if (this.convertUrlToLowercaseBeforeComparison) {
            url = url.toLowerCase();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'"));
            }
        }
        while (iter.hasNext()) {
            EntryHolder entryHolder = (EntryHolder)iter.next();
            boolean matched = matcher.matches(url, entryHolder.getCompiledPattern());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Candidate is: '" + url + "'; pattern is " + entryHolder.getCompiledPattern().getPattern() + "; matched=" + matched));
            }
            if (!matched) continue;
            return entryHolder.getConfigAttributeDefinition();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EntryHolder {
        private ConfigAttributeDefinition configAttributeDefinition;
        private Pattern compiledPattern;

        public EntryHolder(Pattern compiledPattern, ConfigAttributeDefinition attr) {
            this.compiledPattern = compiledPattern;
            this.configAttributeDefinition = attr;
        }

        protected EntryHolder() {
            throw new IllegalArgumentException("Cannot use default constructor");
        }

        public Pattern getCompiledPattern() {
            return this.compiledPattern;
        }

        public ConfigAttributeDefinition getConfigAttributeDefinition() {
            return this.configAttributeDefinition;
        }
    }
}

