/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.intercept.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.intercept.web.AuthenticationEntryPoint;
import net.sf.acegisecurity.intercept.web.FilterInvocation;
import net.sf.acegisecurity.intercept.web.FilterSecurityInterceptor;
import net.sf.acegisecurity.util.PortResolver;
import net.sf.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SecurityEnforcementFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter == null ? (class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter = SecurityEnforcementFilter.class$("net.sf.acegisecurity.intercept.web.SecurityEnforcementFilter")) : class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter));
    public static final String ACEGI_SECURITY_ACCESS_DENIED_EXCEPTION_KEY = "ACEGI_SECURITY_403_EXCEPTION";
    private AuthenticationEntryPoint authenticationEntryPoint;
    private FilterSecurityInterceptor filterSecurityInterceptor;
    private PortResolver portResolver = new PortResolverImpl();
    static /* synthetic */ Class class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter;

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public void setFilterSecurityInterceptor(FilterSecurityInterceptor filterSecurityInterceptor) {
        this.filterSecurityInterceptor = filterSecurityInterceptor;
    }

    public FilterSecurityInterceptor getFilterSecurityInterceptor() {
        return this.filterSecurityInterceptor;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationEntryPoint == null) {
            throw new IllegalArgumentException("authenticationEntryPoint must be specified");
        }
        if (this.filterSecurityInterceptor == null) {
            throw new IllegalArgumentException("filterSecurityInterceptor must be specified");
        }
        if (this.portResolver == null) {
            throw new IllegalArgumentException("portResolver must be specified");
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("HttpServletRequest required");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpServletResponse required");
        }
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        try {
            this.filterSecurityInterceptor.invoke(fi);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Chain processed normally");
            }
        }
        catch (AuthenticationException authentication) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            int port = this.portResolver.getServerPort(request);
            boolean includePort = true;
            if ("http".equals(request.getScheme().toLowerCase()) && port == 80) {
                includePort = false;
            }
            if ("https".equals(request.getScheme().toLowerCase()) && port == 443) {
                includePort = false;
            }
            String targetUrl = request.getScheme() + "://" + request.getServerName() + (includePort ? ":" + port : "") + httpRequest.getContextPath() + fi.getRequestUrl();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication failed - adding target URL to Session: " + targetUrl), (Throwable)((Object)authentication));
            }
            ((HttpServletRequest)request).getSession().setAttribute("ACEGI_SECURITY_TARGET_URL", (Object)targetUrl);
            this.authenticationEntryPoint.commence(request, response);
        }
        catch (AccessDeniedException accessDenied) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Access is denied - sending back forbidden response");
            }
            ((HttpServletRequest)request).getSession().setAttribute(ACEGI_SECURITY_ACCESS_DENIED_EXCEPTION_KEY, (Object)accessDenied);
            this.sendAccessDeniedError(request, response);
        }
        catch (Throwable otherException) {
            throw new ServletException(otherException);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected void sendAccessDeniedError(ServletRequest request, ServletResponse response) throws IOException {
        ((HttpServletResponse)response).sendError(403);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

