/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.SecureContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractIntegrationFilter
implements InitializingBean,
Filter {
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$ui$AbstractIntegrationFilter == null ? (class$net$sf$acegisecurity$ui$AbstractIntegrationFilter = AbstractIntegrationFilter.class$("net.sf.acegisecurity.ui.AbstractIntegrationFilter")) : class$net$sf$acegisecurity$ui$AbstractIntegrationFilter));
    private static final String FILTER_APPLIED = "__acegi_integration_fitlerapplied";
    private Class secureContext = class$net$sf$acegisecurity$context$SecureContextImpl == null ? (class$net$sf$acegisecurity$context$SecureContextImpl = AbstractIntegrationFilter.class$("net.sf.acegisecurity.context.SecureContextImpl")) : class$net$sf$acegisecurity$context$SecureContextImpl;
    static /* synthetic */ Class class$net$sf$acegisecurity$ui$AbstractIntegrationFilter;
    static /* synthetic */ Class class$net$sf$acegisecurity$context$SecureContextImpl;
    static /* synthetic */ Class class$net$sf$acegisecurity$context$SecureContext;

    public void setSecureContext(Class secureContext) {
        this.secureContext = secureContext;
    }

    public Class getSecureContext() {
        return this.secureContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.secureContext == null || !(class$net$sf$acegisecurity$context$SecureContext == null ? (class$net$sf$acegisecurity$context$SecureContext = AbstractIntegrationFilter.class$("net.sf.acegisecurity.context.SecureContext")) : class$net$sf$acegisecurity$context$SecureContext).isAssignableFrom(this.secureContext)) {
            throw new IllegalArgumentException("secureContext must be defined and implement SecureContext");
        }
    }

    public abstract void commitToContainer(ServletRequest var1, Authentication var2);

    public void destroy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object extracted;
        if (request != null && request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter(request, response);
            return;
        }
        if (request != null) {
            request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        }
        if ((extracted = this.extractFromContainer(request)) instanceof Authentication) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication added to ContextHolder from container");
            }
            Authentication auth = (Authentication)extracted;
            SecureContext sc = null;
            if (ContextHolder.getContext() == null || !(ContextHolder.getContext() instanceof SecureContext)) {
                try {
                    sc = (SecureContext)this.secureContext.newInstance();
                }
                catch (InstantiationException ie) {
                    throw new ServletException((Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    throw new ServletException((Throwable)iae);
                }
            } else {
                sc = (SecureContext)ContextHolder.getContext();
            }
            sc.setAuthentication(auth);
            ContextHolder.setContext(sc);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Authentication not added to ContextHolder (could not extract an authentication object from the container which is an instance of Authentication)");
        }
        try {
            try {
                chain.doFilter(request, response);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ServletException se) {
                throw se;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (ContextHolder.getContext() != null && ContextHolder.getContext() instanceof SecureContext) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Updating container with new Authentication object, and then removing Authentication from ContextHolder");
                }
                SecureContext secureContext = (SecureContext)ContextHolder.getContext();
                this.commitToContainer(request, secureContext.getAuthentication());
                secureContext.setAuthentication(null);
                ContextHolder.setContext(secureContext);
                throw throwable;
            }
            if (!logger.isDebugEnabled()) throw throwable;
            logger.debug((Object)"ContextHolder does not contain any authentication information");
            throw throwable;
        }
        if (ContextHolder.getContext() != null && ContextHolder.getContext() instanceof SecureContext) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Updating container with new Authentication object, and then removing Authentication from ContextHolder");
            }
            SecureContext secureContext = (SecureContext)ContextHolder.getContext();
            this.commitToContainer(request, secureContext.getAuthentication());
            secureContext.setAuthentication(null);
            ContextHolder.setContext(secureContext);
            return;
        }
        if (!logger.isDebugEnabled()) return;
        logger.debug((Object)"ContextHolder does not contain any authentication information");
    }

    public abstract Object extractFromContainer(ServletRequest var1);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

