/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.webapp;

import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ui.AbstractIntegrationFilter;

public class HttpSessionIntegrationFilter
extends AbstractIntegrationFilter {
    public static final String ACEGI_SECURITY_AUTHENTICATION_KEY = "ACEGI_SECURITY_AUTHENTICATION";
    private List additionalAttributes = null;

    public void setAdditionalAttributes(List additionalAttributes) {
        this.validateList(additionalAttributes);
        this.additionalAttributes = additionalAttributes;
    }

    public List getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void commitToContainer(ServletRequest request, Authentication authentication) {
        HttpSession httpSession;
        if (request instanceof HttpServletRequest && ((HttpServletRequest)request).isRequestedSessionIdValid() && (httpSession = ((HttpServletRequest)request).getSession()) != null) {
            httpSession.setAttribute(ACEGI_SECURITY_AUTHENTICATION_KEY, (Object)authentication);
            this.updateOtherLocations(httpSession, authentication);
        }
    }

    public Object extractFromContainer(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            Object authObject;
            HttpSession httpSession = null;
            try {
                httpSession = ((HttpServletRequest)request).getSession();
            }
            catch (IllegalStateException ignored) {
                // empty catch block
            }
            if (httpSession != null && (authObject = httpSession.getAttribute(ACEGI_SECURITY_AUTHENTICATION_KEY)) instanceof Authentication) {
                this.updateOtherLocations(httpSession, (Authentication)authObject);
                return authObject;
            }
        }
        return null;
    }

    private void updateOtherLocations(HttpSession session, Authentication authentication) {
        if (this.additionalAttributes == null) {
            return;
        }
        Iterator iter = this.additionalAttributes.iterator();
        while (iter.hasNext()) {
            String attribute = (String)iter.next();
            session.setAttribute(attribute, (Object)authentication);
        }
    }

    private void validateList(List newAdditionalAttributes) {
        if (newAdditionalAttributes != null) {
            Iterator iter = newAdditionalAttributes.iterator();
            while (iter.hasNext()) {
                Object objectToTest = iter.next();
                if (objectToTest instanceof String) continue;
                throw new IllegalArgumentException("List of additional attributes can only contains Strings!");
            }
        }
    }
}

