/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.SecureContext;

public class ContextHolderAwareRequestWrapper
extends HttpServletRequestWrapper {
    public ContextHolderAwareRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getRemoteUser() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return auth.getPrincipal().toString();
    }

    public boolean isUserInRole(String role) {
        return this.isGranted(role);
    }

    private Authentication getAuthentication() {
        if (ContextHolder.getContext() != null && ContextHolder.getContext() instanceof SecureContext) {
            return ((SecureContext)ContextHolder.getContext()).getAuthentication();
        }
        return null;
    }

    private boolean isGranted(String role) {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null || auth.getAuthorities() == null) {
            return false;
        }
        for (int i = 0; i < auth.getAuthorities().length; ++i) {
            if (!role.equals(auth.getAuthorities()[i].getAuthority())) continue;
            return true;
        }
        return false;
    }
}

