/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.digestauth;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextUtils;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.dao.UserCache;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.dao.cache.NullUserCache;
import net.sf.acegisecurity.ui.WebAuthenticationDetails;
import net.sf.acegisecurity.ui.digestauth.DigestProcessingFilterEntryPoint;
import net.sf.acegisecurity.ui.digestauth.NonceExpiredException;
import net.sf.acegisecurity.util.StringSplitUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class DigestProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$ui$digestauth$DigestProcessingFilter == null ? (class$net$sf$acegisecurity$ui$digestauth$DigestProcessingFilter = DigestProcessingFilter.class$("net.sf.acegisecurity.ui.digestauth.DigestProcessingFilter")) : class$net$sf$acegisecurity$ui$digestauth$DigestProcessingFilter));
    private AuthenticationDao authenticationDao;
    private DigestProcessingFilterEntryPoint authenticationEntryPoint;
    private UserCache userCache = new NullUserCache();
    static /* synthetic */ Class class$net$sf$acegisecurity$ui$digestauth$DigestProcessingFilter;

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public AuthenticationDao getAuthenticationDao() {
        return this.authenticationDao;
    }

    public void setAuthenticationEntryPoint(DigestProcessingFilterEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public DigestProcessingFilterEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationDao == null) {
            throw new IllegalArgumentException("An AuthenticationDao is required");
        }
        if (this.authenticationEntryPoint == null) {
            throw new IllegalArgumentException("A DigestProcessingFilterEntryPoint is required");
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String header = httpRequest.getHeader("Authorization");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header received from user agent: " + header));
        }
        if (header != null && header.startsWith("Digest ")) {
            String serverDigestMd5;
            long nonceExpiryTime;
            String section212response = header.substring(7);
            String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)section212response);
            Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap(headerEntries, "=", "\"");
            String username = (String)headerMap.get("username");
            String realm = (String)headerMap.get("realm");
            String nonce = (String)headerMap.get("nonce");
            String uri = (String)headerMap.get("uri");
            String responseDigest = (String)headerMap.get("response");
            String qop = (String)headerMap.get("qop");
            String nc = (String)headerMap.get("nc");
            String cnonce = (String)headerMap.get("cnonce");
            if (username == null || realm == null || nonce == null || uri == null || response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("extracted username: '" + username + "'; realm: '" + username + "'; nonce: '" + username + "'; uri: '" + username + "'; response: '" + username + "'"));
                }
                this.fail(request, response, new BadCredentialsException("Missing mandatory digest value; received header '" + section212response + "'"));
                return;
            }
            if ("auth".equals(qop) && (nc == null || cnonce == null)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("extracted nc: '" + nc + "'; cnonce: '" + cnonce + "'"));
                }
                this.fail(request, response, new BadCredentialsException("Missing mandatory digest value for 'auth' QOP; received header '" + section212response + "'"));
                return;
            }
            if (!this.getAuthenticationEntryPoint().getRealmName().equals(realm)) {
                this.fail(request, response, new BadCredentialsException("Response realm name '" + realm + "' does not match system realm name of '" + this.getAuthenticationEntryPoint().getRealmName() + "'"));
                return;
            }
            if (!Base64.isArrayByteBase64((byte[])nonce.getBytes())) {
                this.fail(request, response, new BadCredentialsException("None is not encoded in Base64; received nonce: '" + nonce + "'"));
                return;
            }
            String nonceAsPlainText = new String(Base64.decodeBase64((byte[])nonce.getBytes()));
            String[] nonceTokens = StringUtils.delimitedListToStringArray((String)nonceAsPlainText, (String)":");
            if (nonceTokens.length != 2) {
                this.fail(request, response, new BadCredentialsException("Nonce should have yielded two tokens but was: '" + nonceAsPlainText + "'"));
                return;
            }
            try {
                nonceExpiryTime = new Long(nonceTokens[0]);
            }
            catch (NumberFormatException nfe) {
                this.fail(request, response, new BadCredentialsException("Nonce token should have yielded a numeric first token, but was: '" + nonceAsPlainText + "'"));
                return;
            }
            String expectedNonceSignature = DigestUtils.md5Hex((String)(nonceExpiryTime + ":" + this.getAuthenticationEntryPoint().getKey()));
            if (!expectedNonceSignature.equals(nonceTokens[1])) {
                this.fail(request, response, new BadCredentialsException("Nonce token compromised: '" + nonceAsPlainText + "'"));
                return;
            }
            boolean loadedFromDao = false;
            UserDetails user = this.userCache.getUserFromCache(username);
            if (user == null) {
                loadedFromDao = true;
                try {
                    user = this.authenticationDao.loadUserByUsername(username);
                }
                catch (UsernameNotFoundException notFound) {
                    this.fail(request, response, new BadCredentialsException("Username '" + username + "' not known"));
                    return;
                }
                if (user == null) {
                    throw new AuthenticationServiceException("AuthenticationDao returned null, which is an interface contract violation");
                }
                this.userCache.putUserInCache(user);
            }
            if (!(serverDigestMd5 = DigestProcessingFilter.generateDigest(username, realm, user.getPassword(), ((HttpServletRequest)request).getMethod(), uri, qop, nonce, nc, cnonce)).equals(responseDigest) && !loadedFromDao) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Digest comparison failure; trying to refresh user from DAO in case password had changed");
                }
                try {
                    user = this.authenticationDao.loadUserByUsername(username);
                }
                catch (UsernameNotFoundException notFound) {
                    this.fail(request, response, new BadCredentialsException("Username '" + username + "' not known"));
                }
                this.userCache.putUserInCache(user);
                serverDigestMd5 = DigestProcessingFilter.generateDigest(username, realm, user.getPassword(), ((HttpServletRequest)request).getMethod(), uri, qop, nonce, nc, cnonce);
            }
            if (!serverDigestMd5.equals(responseDigest)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Expected response: '" + serverDigestMd5 + "' but received: '" + responseDigest + "'; is AuthenticationDao returning clear text passwords?"));
                }
                this.fail(request, response, new BadCredentialsException("Incorrect response"));
                return;
            }
            if (nonceExpiryTime < System.currentTimeMillis()) {
                this.fail(request, response, new NonceExpiredException("Nonce has expired/timed out"));
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication success for user: '" + username + "' with response: '" + responseDigest + "'"));
            }
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(user, user.getPassword());
            authRequest.setDetails(new WebAuthenticationDetails(httpRequest));
            SecureContext sc = SecureContextUtils.getSecureContext();
            sc.setAuthentication(authRequest);
            ContextHolder.setContext(sc);
        }
        chain.doFilter(request, response);
    }

    public static String generateDigest(String username, String realm, String password, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) throws IllegalArgumentException {
        String digest;
        String a1 = username + ":" + realm + ":" + password;
        String a2 = httpMethod + ":" + uri;
        String a1Md5 = new String(DigestUtils.md5Hex((String)a1));
        String a2Md5 = new String(DigestUtils.md5Hex((String)a2));
        if (qop == null) {
            digest = a1Md5 + ":" + nonce + ":" + a2Md5;
        } else if ("auth".equals(qop)) {
            digest = a1Md5 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + a2Md5;
        } else {
            throw new IllegalArgumentException("This method does not support a qop: '" + qop + "'");
        }
        String digestMd5 = new String(DigestUtils.md5Hex((String)digest));
        return digestMd5;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private void fail(ServletRequest request, ServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecureContext sc = SecureContextUtils.getSecureContext();
        sc.setAuthentication(null);
        ContextHolder.setContext(sc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)failed);
        }
        this.authenticationEntryPoint.commence(request, response, failed);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

