/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.CompositeDestinationFilter;
import org.activemq.filter.DestinationPath;
import org.activemq.filter.Filter;
import org.activemq.filter.PrefixDestinationFilter;
import org.activemq.filter.SimpleDestinationFilter;
import org.activemq.filter.WildcardDestinationFilter;
import org.activemq.message.ActiveMQDestination;

public abstract class DestinationFilter
implements Filter {
    public static final String ANY_DESCENDENT = ">";
    public static final String ANY_CHILD = "*";

    public boolean matches(Message message) throws JMSException {
        return this.matches(message.getJMSDestination());
    }

    public abstract boolean matches(Destination var1);

    public static DestinationFilter parseFilter(Destination destination) {
        ActiveMQDestination activeDestination;
        if (destination instanceof ActiveMQDestination && (activeDestination = (ActiveMQDestination)destination).isComposite()) {
            return new CompositeDestinationFilter(activeDestination);
        }
        String[] paths = DestinationPath.getDestinationPaths(destination);
        int idx = paths.length - 1;
        if (idx >= 0) {
            String lastPath = paths[idx];
            if (lastPath.equals(ANY_DESCENDENT)) {
                return new PrefixDestinationFilter(paths);
            }
            while (idx >= 0) {
                if (!(lastPath = paths[idx--]).equals(ANY_CHILD)) continue;
                return new WildcardDestinationFilter(paths);
            }
        }
        return new SimpleDestinationFilter(destination);
    }
}

