/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.DataInput;
import java.io.IOException;
import javax.jms.Destination;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.AbstractPacketReader;
import org.activemq.io.util.WireByteArrayInputStream;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.Packet;
import org.activemq.util.BitArray;

public class ActiveMQMessageReader
extends AbstractPacketReader {
    private AbstractDefaultWireFormat wireFormat;

    ActiveMQMessageReader(AbstractDefaultWireFormat wf) {
        this.wireFormat = wf;
    }

    public int getPacketType() {
        return 6;
    }

    public Packet createPacket() {
        return new ActiveMQMessage();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        int payloadLength;
        short cidlength;
        boolean externalMessageId;
        ActiveMQMessage msg = (ActiveMQMessage)packet;
        BitArray ba = msg.getBitArray();
        ba.readFromStream(dataIn);
        boolean receiptRequired = ba.get(0);
        if (receiptRequired) {
            msg.setReceiptRequired(receiptRequired);
            msg.setId(dataIn.readShort());
        }
        if (externalMessageId = ba.get(16)) {
            msg.setExternalMessageId(externalMessageId);
            msg.setJMSMessageID(this.readUTF(dataIn));
        }
        boolean cachingEnabled = ba.get(18);
        boolean cachingDestination = ba.get(19);
        boolean messagePart = ba.get(17);
        msg.setMessagePart(messagePart);
        if (messagePart) {
            msg.setParentMessageID(dataIn.readUTF());
            msg.setNumberOfParts(dataIn.readShort());
            msg.setPartNumber(dataIn.readShort());
        }
        if (ba.get(1)) {
            int visitedLen = dataIn.readShort();
            for (int i = 0; i < visitedLen; ++i) {
                msg.addBrokerVisited(dataIn.readUTF());
            }
        }
        if (cachingEnabled) {
            short key = dataIn.readShort();
            msg.setJMSClientID((String)this.wireFormat.getValueFromReadCache(key));
            key = dataIn.readShort();
            msg.setProducerKey((String)this.wireFormat.getValueFromReadCache(key));
            if (cachingDestination) {
                key = dataIn.readShort();
                msg.setJMSDestination((Destination)this.wireFormat.getValueFromReadCache(key));
            } else {
                msg.setJMSDestination(ActiveMQDestination.readFromStream(dataIn));
            }
            if (ba.get(7)) {
                key = dataIn.readShort();
                msg.setJMSReplyTo((Destination)this.wireFormat.getValueFromReadCache(key));
            }
            if (ba.get(6)) {
                key = dataIn.readShort();
                msg.setTransactionId(this.wireFormat.getValueFromReadCache(key));
            }
        } else {
            msg.setJMSClientID(super.readUTF(dataIn));
            msg.setProducerKey(dataIn.readUTF());
            msg.setJMSDestination(ActiveMQDestination.readFromStream(dataIn));
            if (ba.get(7)) {
                msg.setJMSReplyTo(ActiveMQDestination.readFromStream(dataIn));
            }
            if (ba.get(6)) {
                if (ba.get(11)) {
                    msg.setTransactionId(ActiveMQXid.read(dataIn));
                } else {
                    msg.setTransactionId(super.readUTF(dataIn));
                }
            } else {
                msg.setTransactionId(null);
            }
        }
        msg.setJMSDeliveryMode(dataIn.readByte());
        msg.setJMSPriority(dataIn.readByte());
        msg.setJMSRedelivered(ba.get(10));
        if (ba.get(2)) {
            msg.setJMSCorrelationID(super.readUTF(dataIn));
        }
        if (ba.get(3)) {
            msg.setJMSType(super.readUTF(dataIn));
        }
        if (ba.get(4)) {
            msg.setEntryBrokerName(super.readUTF(dataIn));
        }
        if (ba.get(5)) {
            msg.setEntryClusterName(super.readUTF(dataIn));
        }
        if (ba.get(8)) {
            msg.setJMSTimestamp(dataIn.readLong());
        }
        if (ba.get(9)) {
            msg.setJMSExpiration(dataIn.readLong());
        }
        if (ba.get(20)) {
            msg.setSequenceNumber(dataIn.readLong());
        } else {
            msg.setSequenceNumber(dataIn.readInt());
        }
        msg.setDeliveryCount(dataIn.readByte());
        if (ba.get(14)) {
            msg.setDispatchedFromDLQ(true);
        }
        if (ba.get(12) && (cidlength = dataIn.readShort()) > 0) {
            int[] cids = new int[cidlength];
            for (int i = 0; i < cids.length; ++i) {
                cids[i] = dataIn.readShort();
            }
            msg.setConsumerNos(cids);
        }
        if (ba.get(13)) {
            msg.setProperties(msg.readMapProperties(dataIn));
        }
        if (ba.get(15) && (payloadLength = dataIn.readInt()) >= 0) {
            if (dataIn instanceof WireByteArrayInputStream) {
                WireByteArrayInputStream wireIn = (WireByteArrayInputStream)((Object)dataIn);
                msg.setBodyAsBytes(wireIn.getRawData(), wireIn.position(), payloadLength);
            } else {
                byte[] payload = new byte[payloadLength];
                dataIn.readFully(payload);
                msg.setBodyAsBytes(payload, 0, payload.length);
            }
        }
    }
}

