/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.activemq.ActiveMQMessageConsumer;
import org.activemq.ActiveMQSession;
import org.activemq.message.ActiveMQQueue;

public class ActiveMQQueueBrowser
implements QueueBrowser,
Enumeration {
    private final ActiveMQSession session;
    private final ActiveMQQueue destination;
    private final String selector;
    private final int cnum;
    private ActiveMQMessageConsumer consumer;
    private boolean closed;

    protected ActiveMQQueueBrowser(ActiveMQSession session, ActiveMQQueue destination, String selector, int cnum) throws JMSException {
        this.session = session;
        this.destination = destination;
        this.selector = selector;
        this.cnum = cnum;
        this.consumer = this.createConsumer();
    }

    private ActiveMQMessageConsumer createConsumer() throws JMSException {
        return new ActiveMQMessageConsumer(this.session, this.destination, "", this.selector, this.cnum, this.session.connection.getPrefetchPolicy().getQueueBrowserPrefetch(), false, true);
    }

    private void destroyConsumer() {
        if (this.consumer == null) {
            return;
        }
        try {
            this.consumer.close();
            this.consumer = null;
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkClosed();
        if (this.consumer == null) {
            this.consumer = this.createConsumer();
        }
        if (this.consumer.messageQueue.size() == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this;
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The Consumer is closed");
        }
    }

    public boolean hasMoreElements() {
        boolean rc;
        if (this.consumer == null) {
            return false;
        }
        boolean bl = rc = this.consumer.messageQueue.size() > 0;
        if (!rc) {
            this.destroyConsumer();
        }
        return rc;
    }

    public Object nextElement() {
        if (this.consumer == null) {
            return null;
        }
        Message answer = null;
        try {
            answer = this.consumer.receiveNoWait();
            if (answer == null) {
                this.destroyConsumer();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return answer;
    }

    public void close() throws JMSException {
        this.destroyConsumer();
        this.closed = true;
    }

    public Queue getQueue() throws JMSException {
        return this.destination;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }
}

