/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.broker.BrokerConnector;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.BrokerContainerFactory;

public class BrokerContext {
    private static final BrokerContext singleton;
    private Map brokersByName = new ConcurrentHashMap();
    private Map connectorsByURL = new ConcurrentHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static BrokerContext getInstance() {
        return singleton;
    }

    public synchronized BrokerContainer getBrokerContainerByName(String url, String name, BrokerContainerFactory factory) throws JMSException {
        BrokerContainer container = (BrokerContainer)this.brokersByName.get(url);
        if (container == null) {
            container = factory.createBrokerContainer(name, this);
            this.brokersByName.put(url, container);
            if (!$assertionsDisabled && this.brokersByName.get(url) != container) {
                throw new AssertionError((Object)"Should have registered the container by now");
            }
            container.start();
        }
        return container;
    }

    public void registerContainer(String url, BrokerContainer container) {
        if (url == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.brokersByName.put(url, container);
    }

    public void deregisterContainer(String url, BrokerContainer container) {
        this.brokersByName.remove(url);
        ArrayList list = new ArrayList();
        Iterator iter = this.brokersByName.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!container.equals(value)) continue;
            list.add(key);
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            Map.Entry key = iter.next();
            this.brokersByName.remove(key);
        }
    }

    public void registerConnector(String url, BrokerConnector connector) {
        this.connectorsByURL.put(url, connector);
    }

    public void deregisterConnector(String urlString) {
        this.connectorsByURL.remove(urlString);
    }

    public BrokerConnector getConnectorByURL(String url) {
        BrokerConnector brokerConnector = (BrokerConnector)this.connectorsByURL.get(url);
        if (brokerConnector == null) {
            if (url.startsWith("reliable:")) {
                return this.getConnectorByURL(url.substring("reliable:".length()));
            }
            if (url.startsWith("list:")) {
                return this.getConnectorByURL(url.substring("list:".length()));
            }
            if (url.startsWith("peer:")) {
                return this.getConnectorByURL(url.substring("peer:".length()));
            }
        }
        return brokerConnector;
    }

    static {
        $assertionsDisabled = !BrokerContext.class.desiredAssertionStatus();
        singleton = new BrokerContext();
    }
}

