/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.activemq.advisories.TempDestinationAdvisoryEvent;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.impl.DefaultBroker;
import org.activemq.message.AbstractPacket;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQObjectMessage;
import org.activemq.message.ConnectionInfo;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.Packet;
import org.activemq.message.ProducerInfo;
import org.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AdvisorySupport {
    private static final Log log = LogFactory.getLog((Class)AdvisorySupport.class);
    private Set advisoryConsumers = new CopyOnWriteArraySet();
    private Set consumers = new CopyOnWriteArraySet();
    private Set producers = new CopyOnWriteArraySet();
    private Set connections = new CopyOnWriteArraySet();
    private Set tempDestConsumers = new CopyOnWriteArraySet();
    private IdGenerator idGen = new IdGenerator();
    private Map tempDestinations = new ConcurrentHashMap();
    private DefaultBroker broker;

    AdvisorySupport(DefaultBroker broker) {
        this.broker = broker;
    }

    void addAdvisory(BrokerClient sender, ConsumerInfo advisory) {
        if (advisory != null && advisory.isAdvisory()) {
            AbstractPacket info;
            this.advisoryConsumers.add(advisory);
            Iterator<Object> i = this.consumers.iterator();
            while (i.hasNext()) {
                info = (ConsumerInfo)i.next();
                this.dispatchToTarget(sender, this.generateAdvisory(advisory, (ConsumerInfo)info));
            }
            i = this.producers.iterator();
            while (i.hasNext()) {
                info = (ProducerInfo)i.next();
                this.dispatchToTarget(sender, this.generateAdvisory(advisory, (ProducerInfo)info));
            }
            i = this.connections.iterator();
            while (i.hasNext()) {
                info = (ConnectionInfo)i.next();
                this.dispatchToTarget(sender, this.generateAdvisory(advisory, (ConnectionInfo)info));
            }
            i = this.tempDestinations.values().iterator();
            while (i.hasNext()) {
                Set set = (Set)i.next();
                Iterator si = set.iterator();
                while (si.hasNext()) {
                    TempDestinationAdvisoryEvent event = (TempDestinationAdvisoryEvent)si.next();
                    this.dispatchToTarget(sender, this.generateAdvisory(advisory, event));
                }
            }
        }
        this.addConsumer(sender, advisory);
    }

    void removeAdvisory(BrokerClient sender, ConsumerInfo info) {
        this.advisoryConsumers.remove(info);
        this.removeConsumer(sender, info);
    }

    private void addConsumer(BrokerClient sender, ConsumerInfo info) {
        this.consumers.remove(info);
        this.consumers.add(info);
        this.dispatchToBroker(sender, this.generateAdvisoryMessage(info, info.getDestination().getTopicForConsumerAdvisory()));
    }

    private void removeConsumer(BrokerClient sender, ConsumerInfo info) {
        this.consumers.remove(info);
        this.dispatchToBroker(sender, this.generateAdvisoryMessage(info, info.getDestination().getTopicForConsumerAdvisory()));
    }

    void addProducer(BrokerClient sender, ProducerInfo info) {
        this.producers.remove(info);
        this.producers.add(info);
        if (info.getDestination() != null) {
            this.dispatchToBroker(sender, this.generateAdvisoryMessage(info, info.getDestination().getTopicForProducerAdvisory()));
        }
    }

    void removeProducer(BrokerClient sender, ProducerInfo info) {
        this.producers.remove(info);
        if (info.getDestination() != null) {
            this.dispatchToBroker(sender, this.generateAdvisoryMessage(info, info.getDestination().getTopicForProducerAdvisory()));
        }
    }

    void addConnection(BrokerClient sender, ConnectionInfo info) {
        this.connections.remove(info);
        this.connections.add(info);
        ActiveMQDestination dest = ActiveMQDestination.createDestination(1, "ActiveMQ.Advisory.Connections.");
        this.dispatchToBroker(sender, this.generateAdvisoryMessage(info, dest));
    }

    void removeConnection(BrokerClient sender, ConnectionInfo info) {
        this.connections.remove(info);
        this.removeAllTempDestinations(sender, info.getClientId());
        ActiveMQDestination dest = ActiveMQDestination.createDestination(1, "ActiveMQ.Advisory.Connections.");
        this.dispatchToBroker(sender, this.generateAdvisoryMessage(info, dest));
    }

    void processTempDestinationAdvisory(BrokerClient sender, ActiveMQMessage message) throws JMSException {
        TempDestinationAdvisoryEvent event = (TempDestinationAdvisoryEvent)((ObjectMessage)message).getObject();
        this.processTempDestinationAdvisory(event);
    }

    private ActiveMQMessage generateAdvisory(ConsumerInfo advisory, ConsumerInfo info) {
        if (this.matchConsumer(advisory, info)) {
            return this.generateAdvisoryMessage(advisory, info, info.getDestination().getTopicForConsumerAdvisory());
        }
        return null;
    }

    private ActiveMQMessage generateAdvisory(ConsumerInfo advisory, ProducerInfo info) {
        if (this.matchProducer(advisory, info)) {
            return this.generateAdvisoryMessage(advisory, info, info.getDestination().getTopicForProducerAdvisory());
        }
        return null;
    }

    private ActiveMQMessage generateAdvisory(ConsumerInfo advisory, ConnectionInfo info) {
        if (this.matchConnection(advisory, info)) {
            String destName = advisory.getDestination().getPhysicalName();
            ActiveMQDestination dest = ActiveMQDestination.createDestination(advisory.getDestination().getDestinationType(), destName);
            return this.generateAdvisoryMessage(advisory, info, dest);
        }
        return null;
    }

    private ActiveMQMessage generateAdvisory(ConsumerInfo advisory, TempDestinationAdvisoryEvent event) {
        if (this.matchTempDestinationAdvisory(advisory, event.getDestination())) {
            return this.generateAdvisoryMessage(advisory, event, event.getDestination().getTopicForTempAdvisory());
        }
        return null;
    }

    boolean matchConsumer(ConsumerInfo advisory, ConsumerInfo info) {
        boolean result = false;
        if (advisory != null && advisory.getDestination() != null && info != null && info.getDestination() != null) {
            ActiveMQDestination advisoryDestination = advisory.getDestination();
            ActiveMQDestination destination = info.getDestination();
            if (advisoryDestination.isConsumerAdvisory()) {
                ActiveMQDestination match = advisoryDestination.getDestinationBeingAdvised();
                return match.matches(destination) || this.matchGeneralAdvisory(advisory, destination);
            }
        }
        return result;
    }

    boolean matchProducer(ConsumerInfo advisory, ProducerInfo info) {
        boolean result = false;
        if (advisory != null && advisory.getDestination() != null && info != null && info.getDestination() != null) {
            ActiveMQDestination advisoryDestination = advisory.getDestination();
            ActiveMQDestination destination = info.getDestination();
            if (advisoryDestination.isProducerAdvisory()) {
                ActiveMQDestination match = advisoryDestination.getDestinationBeingAdvised();
                return match.matches(destination) || this.matchGeneralAdvisory(advisory, destination);
            }
        }
        return result;
    }

    boolean matchConnection(ConsumerInfo advisory, ConnectionInfo info) {
        boolean result = false;
        if (advisory != null && advisory.getDestination() != null && info != null) {
            result = advisory.getDestination().isConnectionAdvisory() && advisory.getDestination().matches(ActiveMQDestination.createDestination(advisory.getDestination().getDestinationType(), "ActiveMQ.Advisory.Connections.")) || this.matchGeneralAdvisory(advisory, advisory.getDestination());
        }
        return result;
    }

    private boolean matchGeneralAdvisory(ConsumerInfo advisory, ActiveMQDestination destination) {
        boolean result;
        boolean bl = result = advisory.getDestination() != null && advisory.getDestination().isAdvisory();
        if (result) {
            ActiveMQDestination match = advisory.getDestination().getDestinationBeingAdvised();
            result = match.matches(destination);
        }
        return result;
    }

    boolean matchTempDestinationAdvisory(ConsumerInfo advisory, ActiveMQDestination destination) {
        ActiveMQDestination advisoryDestination;
        boolean result = false;
        if (advisory != null && advisory.getDestination() != null && (advisoryDestination = advisory.getDestination()).isTempDestinationAdvisory()) {
            ActiveMQDestination match = advisoryDestination.getDestinationBeingAdvised();
            return match.matches(destination) || this.matchGeneralAdvisory(advisory, destination);
        }
        return result;
    }

    private void processTempDestinationAdvisory(TempDestinationAdvisoryEvent event) {
        String clientId = ActiveMQDestination.getClientId(event.getDestination());
        Set set = (Set)this.tempDestinations.get(clientId);
        if (event.isStarted()) {
            if (set == null) {
                set = new CopyOnWriteArraySet();
                this.tempDestinations.put(clientId, set);
            }
            set.add(event);
        } else if (set != null) {
            set.remove(event);
            if (set.isEmpty()) {
                this.tempDestinations.remove(clientId);
            }
        }
    }

    private void removeAllTempDestinations(BrokerClient sender, String clientId) {
        Set set = (Set)this.tempDestinations.remove(clientId);
        if (set != null) {
            Iterator i = set.iterator();
            while (i.hasNext()) {
                TempDestinationAdvisoryEvent event = (TempDestinationAdvisoryEvent)i.next();
                event.setStarted(false);
                this.processTempDestinationAdvisory(event);
                Iterator it = this.advisoryConsumers.iterator();
                while (it.hasNext()) {
                    ConsumerInfo advisory = (ConsumerInfo)it.next();
                    this.dispatchToTarget(sender, this.generateAdvisory(advisory, event));
                }
            }
        }
    }

    private ActiveMQMessage generateAdvisoryMessage(Packet payload, ActiveMQDestination destination) {
        return this.generateAdvisoryMessage(null, payload, destination);
    }

    private ActiveMQMessage generateAdvisoryMessage(ConsumerInfo advisoryTarget, Packet payload, ActiveMQDestination destination) {
        ActiveMQObjectMessage advisoryMsg = null;
        try {
            advisoryMsg = new ActiveMQObjectMessage();
            advisoryMsg.setJMSMessageID(this.idGen.generateId());
            advisoryMsg.setJMSDestination(destination);
            advisoryMsg.setExternalMessageId(true);
            advisoryMsg.setDeliveryCount(1);
            advisoryMsg.setObject((Serializable)((Object)payload));
            if (advisoryTarget != null) {
                advisoryMsg.setConsumerNos(new int[]{advisoryTarget.getConsumerNo()});
            }
        }
        catch (JMSException e) {
            advisoryMsg = null;
            log.warn((Object)"caught an exception generating an advisory", (Throwable)e);
        }
        return advisoryMsg;
    }

    private void dispatchToTarget(BrokerClient target, ActiveMQMessage message) {
        if (target != null && message != null) {
            target.dispatch(message);
        }
    }

    private void dispatchToBroker(BrokerClient sender, ActiveMQMessage message) {
        if (sender != null && message != null) {
            try {
                this.broker.sendMessage(sender, message);
            }
            catch (JMSException e) {
                log.warn((Object)"caught an exception sending an advisory", (Throwable)e);
            }
        }
    }
}

