/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.transaction.xa.XAException;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerAdmin;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.ConsumerInfoListener;
import org.activemq.broker.impl.AdvisorySupport;
import org.activemq.capacity.DelegateCapacityMonitor;
import org.activemq.io.util.MemoryBoundedObjectManager;
import org.activemq.io.util.MemoryBoundedQueueManager;
import org.activemq.jndi.ReadOnlyContext;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.ConnectionInfo;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.MessageAck;
import org.activemq.message.ProducerInfo;
import org.activemq.security.SecurityAdapter;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.MessageContainerAdmin;
import org.activemq.service.MessageContainerManager;
import org.activemq.service.RedeliveryPolicy;
import org.activemq.service.Transaction;
import org.activemq.service.TransactionManager;
import org.activemq.service.boundedvm.DurableQueueBoundedMessageManager;
import org.activemq.service.boundedvm.TransientQueueBoundedMessageManager;
import org.activemq.service.boundedvm.TransientTopicBoundedMessageManager;
import org.activemq.service.impl.DurableTopicMessageContainerManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.PersistenceAdapterFactory;
import org.activemq.store.TransactionStore;
import org.activemq.store.vm.VMPersistenceAdapter;
import org.activemq.store.vm.VMTransactionManager;
import org.activemq.util.Callback;
import org.activemq.util.ExceptionTemplate;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultBroker
extends DelegateCapacityMonitor
implements Broker,
BrokerAdmin {
    private static final Log log = LogFactory.getLog((Class)DefaultBroker.class);
    protected static final String PROPERTY_STORE_DIRECTORY = "activemq.store.dir";
    protected static final String PERSISTENCE_ADAPTER_FACTORY = "activemq.persistenceAdapterFactory";
    protected static final Class[] NEWINSTANCE_PARAMETER_TYPES = new Class[]{File.class};
    private static final long DEFAULT_MAX_MEMORY_USAGE = 0x1400000L;
    private PersistenceAdapter persistenceAdapter;
    private TransactionManager transactionManager;
    private MessageContainerManager[] containerManagers;
    private File tempDir;
    private MemoryBoundedObjectManager memoryManager;
    private MemoryBoundedQueueManager queueManager;
    private TransactionStore preparedTransactionStore;
    private final String brokerName;
    private final String brokerClusterName;
    private Map containerManagerMap;
    private CopyOnWriteArrayList consumerInfoListeners;
    private MessageContainerManager persistentTopicMCM;
    private MessageContainerManager transientTopicMCM;
    private MessageContainerManager transientQueueMCM;
    private DurableQueueBoundedMessageManager persistentQueueMCM;
    private SecurityAdapter securityAdapter;
    private RedeliveryPolicy redeliveryPolicy;
    private DeadLetterPolicy deadLetterPolicy;
    private AdvisorySupport advisory;

    public DefaultBroker(String brokerName, String brokerClusterName, MemoryBoundedObjectManager memoryManager) {
        this.brokerName = brokerName;
        this.brokerClusterName = brokerClusterName;
        this.memoryManager = memoryManager;
        this.queueManager = new MemoryBoundedQueueManager(memoryManager);
        this.setDelegate(memoryManager);
        this.containerManagerMap = new ConcurrentHashMap();
        this.consumerInfoListeners = new CopyOnWriteArrayList();
        this.advisory = new AdvisorySupport(this);
    }

    public DefaultBroker(String brokerName, MemoryBoundedObjectManager memoryManager) {
        this(brokerName, "default", memoryManager);
    }

    public DefaultBroker(String brokerName, String cluserName) {
        this(brokerName, cluserName, new MemoryBoundedObjectManager("Broker Memory Manager", 0x1400000L));
    }

    public DefaultBroker(String brokerName) {
        this(brokerName, new MemoryBoundedObjectManager("Broker Memory Manager", 0x1400000L));
    }

    public DefaultBroker(String brokerName, String brokerClusterName, PersistenceAdapter persistenceAdapter) {
        this(brokerName, brokerClusterName, new MemoryBoundedObjectManager("Broker Memory Manager", 0x1400000L));
        this.persistenceAdapter = persistenceAdapter;
    }

    public DefaultBroker(String brokerName, PersistenceAdapter persistenceAdapter) {
        this(brokerName);
        this.persistenceAdapter = persistenceAdapter;
    }

    public void start() throws JMSException {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new RedeliveryPolicy();
        }
        if (this.deadLetterPolicy == null) {
            this.deadLetterPolicy = new DeadLetterPolicy(this);
        }
        if (this.persistenceAdapter == null) {
            this.persistenceAdapter = this.createPersistenceAdapter();
        }
        this.persistenceAdapter.start();
        if (this.transactionManager == null) {
            this.preparedTransactionStore = this.persistenceAdapter.createTransactionStore();
            this.transactionManager = new VMTransactionManager(this, this.preparedTransactionStore);
        }
        this.transactionManager.start();
        if (this.containerManagerMap.isEmpty()) {
            this.makeDefaultContainerManagers();
        }
        this.getContainerManagers();
        for (int i = 0; i < this.containerManagers.length; ++i) {
            this.containerManagers[i].setDeadLetterPolicy(this.deadLetterPolicy);
            this.containerManagers[i].start();
        }
    }

    public void stop() throws JMSException {
        ExceptionTemplate template = new ExceptionTemplate();
        if (this.containerManagers != null) {
            for (int i = 0; i < this.containerManagers.length; ++i) {
                final MessageContainerManager containerManager = this.containerManagers[i];
                template.run(new Callback(){

                    public void execute() throws Throwable {
                        containerManager.stop();
                    }
                });
            }
        }
        if (this.transactionManager != null) {
            template.run(new Callback(){

                public void execute() throws Throwable {
                    DefaultBroker.this.transactionManager.stop();
                }
            });
        }
        template.run(new Callback(){

            public void execute() throws Throwable {
                DefaultBroker.this.persistenceAdapter.stop();
            }
        });
        template.throwJMSException();
    }

    public void addClient(BrokerClient client, ConnectionInfo info) throws JMSException {
        if (this.securityAdapter != null) {
            this.securityAdapter.authorizeConnection(client, info);
        }
        this.advisory.addConnection(client, info);
    }

    public void removeClient(BrokerClient client, ConnectionInfo info) throws JMSException {
        if (this.transactionManager != null) {
            this.transactionManager.cleanUpClient(client);
        }
        this.advisory.removeConnection(client, info);
    }

    public void addMessageProducer(BrokerClient client, ProducerInfo info) throws JMSException {
        if (this.securityAdapter != null) {
            this.securityAdapter.authorizeProducer(client, info);
        }
        this.advisory.addProducer(client, info);
    }

    public void removeMessageProducer(BrokerClient client, ProducerInfo info) throws JMSException {
        this.advisory.removeProducer(client, info);
    }

    public void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        this.validateConsumer(info);
        if (this.securityAdapter != null) {
            this.securityAdapter.authorizeConsumer(client, info);
        }
        this.advisory.addAdvisory(client, info);
        MessageContainerManager[] array = this.getContainerManagers();
        for (int i = 0; i < array.length; ++i) {
            array[i].addMessageConsumer(client, info);
        }
        this.fireConsumerInfo(client, info);
    }

    public void removeMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        this.validateConsumer(info);
        this.advisory.removeAdvisory(client, info);
        for (int i = 0; i < this.containerManagers.length; ++i) {
            this.containerManagers[i].removeMessageConsumer(client, info);
        }
        this.fireConsumerInfo(client, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        this.checkValid();
        ActiveMQDestination destination = message.getJMSActiveMQDestination();
        if (destination == null) {
            throw new JMSException("No destination specified for the Message");
        }
        if (message.getJMSMessageID() == null && !destination.isAdvisory()) {
            throw new JMSException("No messageID specified for the Message");
        }
        this.associateTransaction(message);
        try {
            if (destination.isComposite()) {
                boolean first = true;
                Iterator iter = destination.getChildDestinations().iterator();
                while (iter.hasNext()) {
                    ActiveMQDestination childDestination = (ActiveMQDestination)iter.next();
                    if (first) {
                        first = false;
                    } else {
                        message = message.shallowCopy();
                    }
                    message.setJMSDestination(childDestination);
                    this.doMessageSend(client, message);
                }
            } else {
                if (destination.isTempDestinationAdvisory() && !client.isBrokerConnection()) {
                    this.advisory.processTempDestinationAdvisory(client, message);
                }
                this.doMessageSend(client, message);
            }
        }
        finally {
            this.disAssociateTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeMessage(BrokerClient client, MessageAck ack) throws JMSException {
        this.associateTransaction(ack);
        try {
            for (int i = 0; i < this.containerManagers.length; ++i) {
                this.containerManagers[i].acknowledgeMessage(client, ack);
            }
        }
        finally {
            this.disAssociateTransaction();
        }
    }

    public void deleteSubscription(String clientId, String subscriberName) throws JMSException {
        for (int i = 0; i < this.containerManagers.length; ++i) {
            this.containerManagers[i].deleteSubscription(clientId, subscriberName);
        }
    }

    public void startTransaction(BrokerClient client, String transactionId) throws JMSException {
        this.transactionManager.createLocalTransaction(client, transactionId);
    }

    public void commitTransaction(BrokerClient client, String transactionId) throws JMSException {
        try {
            Transaction transaction = this.transactionManager.getLocalTransaction(transactionId);
            transaction.commit(true);
        }
        catch (XAException e) {
            throw (JMSException)new JMSException(e.getMessage()).initCause((Throwable)e);
        }
    }

    public void rollbackTransaction(BrokerClient client, String transactionId) throws JMSException {
        try {
            Transaction transaction = this.transactionManager.getLocalTransaction(transactionId);
            transaction.rollback();
        }
        catch (XAException e) {
            throw (JMSException)new JMSException(e.getMessage()).initCause((Throwable)e);
        }
    }

    public void startTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        this.transactionManager.createXATransaction(client, xid);
    }

    public int prepareTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        Transaction transaction = this.transactionManager.getXATransaction(xid);
        return transaction.prepare();
    }

    public void rollbackTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        Transaction transaction = this.transactionManager.getXATransaction(xid);
        transaction.rollback();
    }

    public void commitTransaction(BrokerClient client, ActiveMQXid xid, boolean onePhase) throws XAException {
        Transaction transaction = this.transactionManager.getXATransaction(xid);
        transaction.commit(onePhase);
    }

    public ActiveMQXid[] getPreparedTransactions(BrokerClient client) throws XAException {
        return this.transactionManager.getPreparedXATransactions();
    }

    public File getTempDir() {
        if (this.tempDir == null) {
            String dirName = System.getProperty("activemq.store.tempdir", "ActiveMQTemp");
            this.tempDir = new File(dirName);
        }
        return this.tempDir;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getBrokerClusterName() {
        return this.brokerClusterName;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public MessageContainerManager[] getContainerManagers() {
        if (this.containerManagers == null) {
            this.containerManagers = this.createContainerManagers();
        }
        return this.containerManagers;
    }

    public Map getContainerManagerMap() {
        return this.containerManagerMap;
    }

    public void setContainerManagerMap(Map containerManagerMap) {
        this.containerManagerMap = containerManagerMap;
        this.containerManagers = null;
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.persistenceAdapter;
    }

    public void setPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public SecurityAdapter getSecurityAdapter() {
        return this.securityAdapter;
    }

    public void setSecurityAdapter(SecurityAdapter securityAdapter) {
        this.securityAdapter = securityAdapter;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public TransactionStore getPreparedTransactionStore() {
        return this.preparedTransactionStore;
    }

    public void setPreparedTransactionStore(TransactionStore preparedTransactionStore) {
        this.preparedTransactionStore = preparedTransactionStore;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public long getMaximumMemoryUsage() {
        return this.memoryManager.getValueLimit();
    }

    public void setMaximumMemoryUsage(long maximumMemoryUsage) {
        this.memoryManager.setValueLimit(maximumMemoryUsage);
    }

    public Context getDestinationContext(Hashtable environment) {
        ConcurrentHashMap data = new ConcurrentHashMap();
        Iterator iter = this.containerManagerMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = entry.getKey().toString();
            MessageContainerManager manager = (MessageContainerManager)entry.getValue();
            ReadOnlyContext context = new ReadOnlyContext(environment, manager.getDestinations());
            data.put(name, context);
        }
        return new ReadOnlyContext(environment, (Map)data);
    }

    protected void doMessageSend(BrokerClient client, ActiveMQMessage message) throws JMSException {
        ActiveMQDestination dest;
        if (this.securityAdapter != null) {
            this.securityAdapter.authorizeSendMessage(client, message);
        }
        if ((dest = message.getJMSActiveMQDestination()).isTopic()) {
            if (message.isPersistent() && !dest.isTemporary()) {
                this.persistentTopicMCM.sendMessage(client, message);
            }
            this.transientTopicMCM.sendMessage(client, message);
        } else {
            this.transientQueueMCM.sendMessage(client, message);
            this.persistentQueueMCM.sendMessage(client, message);
        }
    }

    protected PersistenceAdapter createPersistenceAdapter() throws JMSException {
        File directory = new File(this.getStoreDirectory());
        PersistenceAdapter answer = null;
        String property = System.getProperty(PERSISTENCE_ADAPTER_FACTORY);
        if (property != null) {
            answer = this.tryCreatePersistenceAdapter(property, directory, false);
        }
        if (answer == null) {
            answer = this.tryCreatePersistenceAdapter("org.activemq.broker.impl.DefaultPersistenceAdapterFactory", directory, true);
        }
        if (answer != null) {
            return answer;
        }
        log.warn((Object)"Default message store (journal+derby) could not be found in the classpath or property 'activemq.persistenceAdapterFactory' not specified so defaulting to use RAM based message persistence");
        return new VMPersistenceAdapter();
    }

    protected PersistenceAdapter tryCreatePersistenceAdapter(String className, File directory, boolean ignoreErrors) throws JMSException {
        block4: {
            Class adapterClass = this.loadClass(className, ignoreErrors);
            if (adapterClass != null) {
                try {
                    PersistenceAdapterFactory factory = (PersistenceAdapterFactory)adapterClass.newInstance();
                    PersistenceAdapter answer = factory.createPersistenceAdapter(directory, this.memoryManager);
                    log.info((Object)("Persistence adapter created using: " + className));
                    return answer;
                }
                catch (IOException cause) {
                    throw this.createInstantiateAdapterException(className, cause);
                }
                catch (Throwable e) {
                    if (ignoreErrors) break block4;
                    throw this.createInstantiateAdapterException(className, e);
                }
            }
        }
        return null;
    }

    protected JMSException createInstantiateAdapterException(String className, Throwable e) {
        return JMSExceptionHelper.newJMSException("Persistence adapter could not be created using: " + className + ". Reason: " + e, e);
    }

    protected Class loadClass(String name, boolean ignoreErrors) throws JMSException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return this.getClass().getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e2) {
                if (ignoreErrors) {
                    log.trace((Object)("Could not find class: " + name + " on the classpath"));
                    return null;
                }
                throw JMSExceptionHelper.newJMSException("Could not find class: " + name + " on the classpath. Reason: " + e, e);
            }
        }
    }

    protected String getStoreDirectory() {
        return System.getProperty(PROPERTY_STORE_DIRECTORY, "ActiveMQ");
    }

    protected MessageContainerManager[] createContainerManagers() {
        int size = this.containerManagerMap.size();
        MessageContainerManager[] answer = new MessageContainerManager[size];
        this.containerManagerMap.values().toArray(answer);
        return answer;
    }

    protected void makeDefaultContainerManagers() {
        this.transientTopicMCM = new TransientTopicBoundedMessageManager(this.queueManager);
        this.containerManagerMap.put("transientTopicContainer", this.transientTopicMCM);
        this.persistentTopicMCM = new DurableTopicMessageContainerManager(this.persistenceAdapter, this.redeliveryPolicy, this.deadLetterPolicy);
        this.containerManagerMap.put("persistentTopicContainer", this.persistentTopicMCM);
        this.persistentQueueMCM = new DurableQueueBoundedMessageManager(this.persistenceAdapter, this.queueManager, this.redeliveryPolicy, this.deadLetterPolicy);
        this.containerManagerMap.put("persistentQueueContainer", this.persistentQueueMCM);
        this.transientQueueMCM = new TransientQueueBoundedMessageManager(this.queueManager, this.redeliveryPolicy, this.deadLetterPolicy);
        this.containerManagerMap.put("transientQueueContainer", this.transientQueueMCM);
    }

    protected void validateConsumer(ConsumerInfo info) throws JMSException {
        if (info.getConsumerId() == null) {
            throw new JMSException("No consumerId specified for the ConsumerInfo");
        }
    }

    protected void checkValid() throws JMSException {
        if (this.containerManagers == null) {
            throw new JMSException("This Broker has not yet been started. Ensure start() is called before invoking action methods");
        }
    }

    public void addConsumerInfoListener(ConsumerInfoListener l) {
        this.consumerInfoListeners.add((Object)l);
    }

    public void removeConsumerInfoListener(ConsumerInfoListener l) {
        this.consumerInfoListeners.remove((Object)l);
    }

    protected void fireConsumerInfo(BrokerClient client, ConsumerInfo info) {
        Iterator i = this.consumerInfoListeners.iterator();
        while (i.hasNext()) {
            ConsumerInfoListener l = (ConsumerInfoListener)i.next();
            l.onConsumerInfo(client, info);
        }
    }

    public MessageContainerManager getPersistentTopicContainerManager() {
        return this.persistentTopicMCM;
    }

    public MessageContainerManager getTransientTopicContainerManager() {
        return this.transientTopicMCM;
    }

    public MessageContainerManager getPersistentQueueContainerManager() {
        return this.persistentQueueMCM;
    }

    public MessageContainerManager getTransientQueueContainerManager() {
        return this.transientQueueMCM;
    }

    public BrokerAdmin getBrokerAdmin() {
        return this;
    }

    public void createMessageContainer(ActiveMQDestination dest) throws JMSException {
        for (int i = 0; i < this.containerManagers.length; ++i) {
            this.containerManagers[i].createMessageContainer(dest);
        }
    }

    public void destoryMessageContainer(ActiveMQDestination dest) throws JMSException {
        for (int i = 0; i < this.containerManagers.length; ++i) {
            this.containerManagers[i].destroyMessageContainer(dest);
        }
    }

    public MessageContainerAdmin getMessageContainerAdmin(ActiveMQDestination dest) throws JMSException {
        for (int i = 0; i < this.containerManagers.length; ++i) {
            Map messageContainerAdmins = this.containerManagers[i].getMessageContainerAdmins();
            MessageContainerAdmin mca = (MessageContainerAdmin)messageContainerAdmins.get(dest);
            if (mca == null) continue;
            return mca;
        }
        return null;
    }

    public MessageContainerAdmin[] listMessageContainerAdmin() throws JMSException {
        ArrayList<MessageContainerAdmin> l = new ArrayList<MessageContainerAdmin>();
        for (int i = 0; i < this.containerManagers.length; ++i) {
            Map messageContainerAdmins = this.containerManagers[i].getMessageContainerAdmins();
            Iterator iter = messageContainerAdmins.values().iterator();
            while (iter.hasNext()) {
                MessageContainerAdmin mca = (MessageContainerAdmin)iter.next();
                l.add(mca);
            }
        }
        MessageContainerAdmin[] answer = new MessageContainerAdmin[l.size()];
        l.toArray(answer);
        return answer;
    }

    public void sendToDeadLetterQueue(String deadLetterName, ActiveMQMessage message) throws JMSException {
        if (this.persistentQueueMCM != null) {
            this.persistentQueueMCM.sendToDeadLetterQueue(deadLetterName, message);
            log.debug((Object)(message + " sent to DLQ: " + deadLetterName));
        }
    }

    private final void associateTransaction(ActiveMQMessage message) throws JMSException {
        Transaction transaction;
        if (message.isPartOfTransaction()) {
            if (message.isXaTransacted()) {
                try {
                    transaction = this.transactionManager.getXATransaction((ActiveMQXid)message.getTransactionId());
                }
                catch (XAException e) {
                    throw (JMSException)new JMSException(e.getMessage()).initCause((Throwable)e);
                }
            } else {
                transaction = this.transactionManager.getLocalTransaction((String)message.getTransactionId());
            }
        } else {
            transaction = null;
        }
        TransactionManager.setContexTransaction(transaction);
    }

    private void disAssociateTransaction() {
        TransactionManager.setContexTransaction(null);
    }

    private void associateTransaction(MessageAck ack) throws JMSException {
        Transaction transaction;
        if (ack.isPartOfTransaction()) {
            if (ack.isXaTransacted()) {
                try {
                    transaction = this.transactionManager.getXATransaction((ActiveMQXid)ack.getTransactionId());
                }
                catch (XAException e) {
                    throw (JMSException)new JMSException(e.getMessage()).initCause((Throwable)e);
                }
            } else {
                transaction = this.transactionManager.getLocalTransaction((String)ack.getTransactionId());
            }
        } else {
            transaction = null;
        }
        TransactionManager.setContexTransaction(transaction);
    }

    public MemoryBoundedObjectManager getMemoryManager() {
        return this.memoryManager;
    }

    public MemoryBoundedQueueManager getQueueManager() {
        return this.queueManager;
    }
}

