/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.activemq.io.util.MemoryBoundedObject;
import org.activemq.io.util.MemoryBoundedQueueManager;
import org.activemq.io.util.MemoryManageable;
import org.activemq.service.QueueListEntry;
import org.activemq.service.impl.DefaultQueueList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryBoundedQueue
implements MemoryBoundedObject {
    private static final Log log = LogFactory.getLog((Class)MemoryBoundedQueue.class);
    private static final int OBJECT_OVERHEAD = 50;
    private static final int WAIT_TIMEOUT = 100;
    private final MemoryBoundedQueueManager manager;
    private final String name;
    private final Object outLock = new Object();
    private final Object inLock = new Object();
    private final DefaultQueueList internalList = new DefaultQueueList();
    private boolean stopped = false;
    private boolean closed = false;
    private SynchronizedLong memoryUsedByThisQueue = new SynchronizedLong(0L);

    public MemoryBoundedQueue(MemoryBoundedQueueManager manager, String name) {
        this.manager = manager;
        this.name = name;
        this.manager.add(this);
    }

    public String toString() {
        return "MemoryBoundedQueue{ size=" + this.size() + ", memory usage=" + this.memoryUsedByThisQueue + " }";
    }

    public int size() {
        return this.internalList.size();
    }

    public long getLocalMemoryUsedByThisQueue() {
        return this.memoryUsedByThisQueue.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.clear();
            this.closed = true;
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notifyAll();
            }
            object = this.inLock;
            synchronized (object) {
                this.inLock.notifyAll();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.manager.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueNoBlock(MemoryManageable packet) {
        if (!this.closed) {
            this.internalList.add(packet);
            this.incrementMemoryUsed(packet);
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(MemoryManageable packet) {
        if (!this.manager.isFull()) {
            this.enqueueNoBlock(packet);
        } else {
            Object object = this.inLock;
            synchronized (object) {
                try {
                    while (this.manager.isFull() && !this.closed) {
                        log.warn((Object)"Queue is full, waiting for it to be dequeued.");
                        this.inLock.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.enqueueNoBlock(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueFirstNoBlock(MemoryManageable packet) {
        if (!this.closed) {
            this.internalList.addFirst(packet);
            this.incrementMemoryUsed(packet);
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAllFirstNoBlock(List packets) {
        if (!this.closed) {
            this.internalList.addAllFirst(packets);
            Iterator iterator = packets.iterator();
            Iterator iter = packets.iterator();
            while (iter.hasNext()) {
                MemoryManageable packet = (MemoryManageable)iter.next();
                this.incrementMemoryUsed(packet);
            }
            Object object = this.outLock;
            synchronized (object) {
                this.outLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFirst(MemoryManageable packet) throws InterruptedException {
        if (!this.manager.isFull()) {
            this.enqueueFirstNoBlock(packet);
        } else {
            Object object = this.inLock;
            synchronized (object) {
                while (this.manager.isFull() && !this.closed) {
                    this.inLock.wait(100L);
                }
            }
            this.enqueueFirstNoBlock(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManageable dequeue() throws InterruptedException {
        MemoryManageable result = null;
        Object object = this.outLock;
        synchronized (object) {
            while (this.internalList.isEmpty() && !this.closed) {
                this.outLock.wait(100L);
            }
            result = this.dequeueNoWait();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManageable dequeue(long timeInMillis) throws InterruptedException {
        MemoryManageable result = null;
        if (timeInMillis == 0L) {
            result = this.dequeue();
        } else {
            Object object = this.outLock;
            synchronized (object) {
                long start;
                long waitTime = timeInMillis;
                long l = start = timeInMillis <= 0L ? 0L : System.currentTimeMillis();
                while (!this.closed && (result = this.dequeueNoWait()) == null && waitTime > 0L) {
                    this.outLock.wait(waitTime);
                    waitTime = timeInMillis - (System.currentTimeMillis() - start);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManageable dequeueNoWait() throws InterruptedException {
        MemoryManageable packet = null;
        Object object = this.outLock;
        synchronized (object) {
            while (this.stopped && !this.closed) {
                this.outLock.wait(100L);
            }
        }
        packet = (MemoryManageable)this.internalList.removeFirst();
        this.decrementMemoryUsed(packet);
        if (packet != null) {
            object = this.inLock;
            synchronized (object) {
                this.inLock.notify();
            }
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.outLock;
        synchronized (object) {
            return !this.stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.outLock;
        synchronized (object) {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.outLock;
        synchronized (object) {
            this.stopped = false;
            this.outLock.notifyAll();
        }
        object = this.inLock;
        synchronized (object) {
            this.inLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MemoryManageable packet) {
        boolean result = false;
        if (!this.internalList.isEmpty()) {
            result = this.internalList.remove(packet);
        }
        if (result) {
            this.decrementMemoryUsed(packet);
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notify();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManageable remove(Object id) {
        MemoryManageable result = null;
        QueueListEntry entry = this.internalList.getFirstEntry();
        try {
            while (entry != null) {
                MemoryManageable p = (MemoryManageable)entry.getElement();
                if (p.getMemoryId().equals(id)) {
                    result = p;
                    this.remove(p);
                    break;
                }
                entry = this.internalList.getNextEntry(entry);
            }
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notify();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        while (!this.internalList.isEmpty()) {
            MemoryManageable packet = (MemoryManageable)this.internalList.removeFirst();
            this.decrementMemoryUsed(packet);
        }
        Object object = this.inLock;
        synchronized (object) {
            this.inLock.notifyAll();
        }
    }

    public boolean isEmpty() {
        return this.internalList.isEmpty();
    }

    public MemoryManageable get(int index) {
        return (MemoryManageable)this.internalList.get(index);
    }

    public List getContents() {
        Object[] array = this.internalList.toArray();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    private void incrementMemoryUsed(MemoryManageable packet) {
        if (packet != null) {
            int size = 50;
            if (packet != null && packet.incrementMemoryReferenceCount() == 1) {
                size += packet.getMemoryUsage();
            }
            this.memoryUsedByThisQueue.add((long)size);
            this.manager.incrementMemoryUsed(size);
        }
    }

    private void decrementMemoryUsed(MemoryManageable packet) {
        if (packet != null) {
            int size = 50;
            if (packet != null && packet.decrementMemoryReferenceCount() == 0) {
                size += packet.getMemoryUsage();
            }
            this.memoryUsedByThisQueue.subtract((long)size);
            this.manager.decrementMemoryUsed(size);
        }
    }

    public String getName() {
        return this.name;
    }
}

