/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.activemq.io.util.MemoryBoundedObjectManager;
import org.activemq.io.util.MemoryBoundedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryBoundedQueueManager {
    private static final Log log = LogFactory.getLog((Class)MemoryBoundedQueueManager.class);
    private final ConcurrentHashMap activeQueues = new ConcurrentHashMap();
    private final MemoryBoundedObjectManager memoryManager;

    public MemoryBoundedQueueManager(MemoryBoundedObjectManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public MemoryBoundedQueue getMemoryBoundedQueue(String name) {
        MemoryBoundedQueue result = (MemoryBoundedQueue)this.activeQueues.get((Object)name);
        if (result == null) {
            result = new MemoryBoundedQueue(this, name);
            this.activeQueues.put((Object)name, (Object)result);
        }
        return result;
    }

    public void close() {
        this.memoryManager.close();
    }

    public MemoryBoundedObjectManager getMemoryManager() {
        return this.memoryManager;
    }

    public int getCurrentCapacity() {
        return this.memoryManager.getCurrentCapacity();
    }

    public void add(MemoryBoundedQueue queue) {
        this.memoryManager.add(queue);
    }

    public void remove(MemoryBoundedQueue queue) {
        this.memoryManager.remove(queue);
        this.activeQueues.remove((Object)queue.getName());
    }

    public boolean isFull() {
        return this.memoryManager.isFull();
    }

    public void incrementMemoryUsed(int size) {
        this.memoryManager.incrementMemoryUsed(size);
    }

    public void decrementMemoryUsed(int size) {
        this.memoryManager.decrementMemoryUsed(size);
    }

    public List getMemoryBoundedQueues() {
        return new ArrayList(this.activeQueues.values());
    }

    public String dumpContents() {
        String result = "Memory = " + this.memoryManager.getTotalMemoryUsedSize() + " , capacity = " + this.memoryManager.getCurrentCapacity() + "\n";
        Iterator i = this.activeQueues.values().iterator();
        while (i.hasNext()) {
            MemoryBoundedQueue q = (MemoryBoundedQueue)i.next();
            result = result + "\t" + q.getName() + " enqueued = " + q.getContents().size() + " memory = " + q.getLocalMemoryUsedByThisQueue() + "\n";
        }
        result = result + "\n\n";
        return result;
    }
}

