/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.boundedvm;

import java.util.List;
import javax.jms.JMSException;
import org.activemq.broker.BrokerClient;
import org.activemq.filter.Filter;
import org.activemq.io.util.MemoryBoundedQueue;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.boundedvm.DurableMessagePointer;
import org.activemq.service.boundedvm.DurableSubscription;

public class DurableQueueSubscription
extends DurableSubscription {
    private MemoryBoundedQueue dispatchedQueue;
    private MemoryBoundedQueue ackedQueue;

    public DurableQueueSubscription(BrokerClient client, MemoryBoundedQueue dispatchedQueue, MemoryBoundedQueue ackQueue, Filter filter, ConsumerInfo info) {
        super(filter, info, client);
        this.dispatchedQueue = dispatchedQueue;
        this.ackedQueue = ackQueue;
    }

    public boolean isTarget(ActiveMQMessage message) throws JMSException {
        boolean result = false;
        if (!(message == null || this.client.isClusteredConnection() && message.isEntryCluster(this.clusterName) && !message.isEntryBroker(this.brokerName))) {
            result = this.filter.matches(message);
        }
        return result;
    }

    public boolean canAcceptMessages() {
        return this.dispatchedQueue.size() <= this.consumerInfo.getPrefetchNumber();
    }

    public void doDispatch(DurableMessagePointer message) throws JMSException {
        this.dispatchedQueue.enqueue(message);
        ActiveMQMessage msg = message.getMessage().shallowCopy();
        msg.setConsumerNos(new int[]{this.consumerInfo.getConsumerNo()});
        this.client.dispatch(msg);
    }

    public DurableMessagePointer acknowledgeMessage(String id) {
        return (DurableMessagePointer)this.dispatchedQueue.remove(id);
    }

    public List getUndeliveredMessages() {
        return this.dispatchedQueue.getContents();
    }

    public void close() {
        super.close();
        this.dispatchedQueue.close();
        this.ackedQueue.close();
    }

    public boolean hasAckedMessage() {
        return !this.ackedQueue.isEmpty();
    }

    public void addAckedMessage(DurableMessagePointer message) {
        this.ackedQueue.enqueueNoBlock(message);
    }

    public List listAckedMessages() {
        return this.ackedQueue.getContents();
    }

    public void removeAllAckedMessages() {
        this.ackedQueue.clear();
    }

    public boolean isBrowser() {
        return this.consumerInfo.isBrowser();
    }
}

