/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.vm;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageIdentity;
import org.activemq.store.MessageStore;
import org.activemq.store.RecoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)VMMessageStore.class);
    protected Map messageTable;
    protected MessageIdentity lastMessageIdentity;

    public VMMessageStore() {
        this(new LinkedHashMap());
    }

    public VMMessageStore(LinkedHashMap messageTable) {
        this.messageTable = Collections.synchronizedMap(messageTable);
    }

    public synchronized void addMessage(ActiveMQMessage message) throws JMSException {
        this.messageTable.put(message.getJMSMessageID(), message);
        this.lastMessageIdentity = message.getJMSMessageIdentity();
    }

    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        String messageID = identity.getMessageID();
        return (ActiveMQMessage)this.messageTable.get(messageID);
    }

    public void removeMessage(MessageAck ack) throws JMSException {
        this.messageTable.remove(ack.getMessageID());
    }

    public void removeMessage(MessageIdentity msgId) throws JMSException {
        this.messageTable.remove(msgId.getMessageID());
    }

    public void recover(RecoveryListener listener) throws JMSException {
        Iterator iter = this.messageTable.values().iterator();
        while (iter.hasNext()) {
            ActiveMQMessage msg = (ActiveMQMessage)iter.next();
            listener.recoverMessage(msg.getJMSMessageIdentity());
        }
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    public void removeAllMessages() throws JMSException {
        this.messageTable.clear();
    }
}

