/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.activemq.advisories.ProducerAdvisoryEvent;
import org.activemq.advisories.ProducerAdvisoryEventListener;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ProducerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProducerAdvisor
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)ProducerAdvisor.class);
    private Connection connection;
    private ActiveMQDestination destination;
    private Session session;
    private List listeners = new CopyOnWriteArrayList();
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private Map activeProducers = new ConcurrentHashMap();

    public ProducerAdvisor(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = ActiveMQDestination.transformDestination(destination);
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.session = this.connection.createSession(false, 1);
            MessageConsumer consumer = this.session.createConsumer((Destination)this.destination.getTopicForProducerAdvisory());
            consumer.setMessageListener((MessageListener)this);
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void addListener(ProducerAdvisoryEventListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ProducerAdvisoryEventListener l) {
        this.listeners.remove(l);
    }

    public boolean isActive(Destination destination) {
        return this.activeProducers.containsKey(destination);
    }

    public Set activeProducers(Destination destination) {
        Set set = (Set)this.activeProducers.get(destination);
        return set != null ? set : new CopyOnWriteArraySet();
    }

    public void onMessage(Message msg) {
        if (msg instanceof ObjectMessage) {
            try {
                ProducerInfo info = (ProducerInfo)((ObjectMessage)msg).getObject();
                this.updateActiveProducers(info);
                ProducerAdvisoryEvent event = new ProducerAdvisoryEvent(info);
                this.fireEvent(event);
            }
            catch (JMSException e) {
                log.error((Object)("Failed to process message: " + msg));
            }
        }
    }

    private void fireEvent(ProducerAdvisoryEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ProducerAdvisoryEventListener l = (ProducerAdvisoryEventListener)i.next();
            l.onEvent(event);
        }
    }

    private void updateActiveProducers(ProducerInfo info) {
        Set set = (Set)this.activeProducers.get(info.getDestination());
        if (info.isStarted()) {
            if (set == null) {
                set = new CopyOnWriteArraySet();
                this.activeProducers.put(info.getDestination(), set);
            }
            set.add(info);
        } else if (set != null) {
            set.remove(info);
            if (set.isEmpty()) {
                this.activeProducers.remove(set);
            }
        }
    }
}

