/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

public class ByteArray {
    private byte[] buf;
    private int offset;
    private int length;

    public ByteArray() {
    }

    public ByteArray(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteArray(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    public void clear() {
        this.buf = null;
        this.offset = 0;
        this.length = 0;
    }

    public void reset(byte[] buf) {
        if (buf != null) {
            this.reset(buf, 0, buf.length);
        } else {
            this.clear();
        }
    }

    public void reset(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public void setBuf(byte[] buf) {
        this.buf = buf;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte get(int position) {
        return this.buf[this.offset + position];
    }

    public ByteArray copy() {
        ByteArray result = new ByteArray();
        if (this.buf != null) {
            byte[] data = new byte[this.length];
            System.arraycopy(this.buf, this.offset, data, 0, this.length);
            result.reset(data);
        }
        return result;
    }
}

