/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import org.activemq.io.util.ByteArray;

public class ByteArrayFragmentation {
    public static final int DEFAULT_FRAGMENTATION_LIMIT = 65536;
    private int fragmentationLimit = 65536;

    public int getFragmentationLimit() {
        return this.fragmentationLimit;
    }

    public void setFragmentationLimit(int fragmentationLimit) {
        this.fragmentationLimit = fragmentationLimit;
    }

    public boolean doFragmentation(ByteArray ba) {
        return ba != null && ba.getLength() > this.fragmentationLimit;
    }

    public ByteArray[] fragment(ByteArray ba) {
        ByteArray[] answer = null;
        if (ba != null) {
            if (this.doFragmentation(ba)) {
                int bytesRemaining = ba.getLength();
                int numberOfParts = bytesRemaining / this.fragmentationLimit;
                answer = new ByteArray[numberOfParts];
                int partLength = ba.getLength() / numberOfParts + 1;
                byte[] buffer = ba.getBuf();
                int offset = ba.getOffset();
                int count = 0;
                while (bytesRemaining > 0) {
                    answer[count] = new ByteArray(buffer, offset, partLength);
                    offset += partLength;
                    partLength = partLength < (bytesRemaining -= partLength) ? partLength : bytesRemaining;
                    ++count;
                }
            } else {
                answer = new ByteArray[]{ba};
            }
        }
        return answer;
    }

    public ByteArray assemble(ByteArray[] array) {
        ByteArray answer = new ByteArray();
        if (array != null) {
            int length = 0;
            for (int i = 0; i < array.length; ++i) {
                length += array[i].getLength();
            }
            byte[] data = new byte[length];
            int offset = 0;
            for (int i = 0; i < array.length; ++i) {
                System.arraycopy(array[i].getBuf(), array[i].getOffset(), data, offset, array[i].getLength());
                offset += array[i].getLength();
                answer.reset(data);
            }
        }
        return answer;
    }
}

